/**
 * geis_instance_table.h
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.	 See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin St, Fifth Floor, Boston, MA  02110-1301 US
 */
#ifndef GEIS_INSTANCE_TABLE_H_
#define GEIS_INSTANCE_TABLE_H_

#include "geis_config.h"
#include <geis/geis.h>

/**
 * A map from XCB window IDs to geisInstances.
 */
typedef struct _GeisInstanceTable *GeisInstanceTable;

GeisInstanceTable geis_instance_table_new(int size_hint);

void geis_instance_table_add(GeisInstanceTable type_table,
                             GeisInstance      instance);

GeisInstance geis_instance_table_get(GeisInstanceTable type_table,
                                     uint32_t          window_id);

void geis_instance_table_free(GeisInstanceTable type_table);

#endif /* GEIS_INSTANCE_TABLE_H_ */
