#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2011-2012 Canonical, Ltd.
#
# Authors:
#  Tiago Salem Herrmann <tiago.herrmann@canonical.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import logging
import sys
import os
import dbus

logger = logging.getLogger('UfA.AndroidMessages')

class AndroidMessages():

    def __init__(self):
        self.bus = dbus.SessionBus()
        self.init_android_messages_proxy()

    def connect_android_messages_bus(self):
        try:
            android_object = self.bus.get_object('com.canonical.Android',
                                                    '/com/canonical/android/messages/Messages')
            self.android_messages_proxy = dbus.Interface(android_object,
                                                    'com.canonical.android.messages.Messages')
            self.android_messages_proxy.connect_to_signal('messageReceived', self.messageReceived)
        except:
            # bus not available yet
            pass

    def init_android_messages_proxy(self):
        self.connect_android_messages_bus()
        self.bus.add_signal_receiver(self.messages_got_signal_owner_changed, 'NameOwnerChanged', 'org.freedesktop.DBus', arg0='com.canonical.Android')

    def messages_got_signal_owner_changed(self, name, old_owner, new_owner):
        if name == 'com.canonical.Android':
            if len(new_owner) != 0:
                self.connect_android_messages_bus()

    def listConversationsBegin(self):
        return self.android_messages_proxy.listConversationsBegin()

    def listConversationsNextPage(self, token):
        return self.android_messages_proxy.listConversationsNextPage(token)

    def listConversationsEnd(self, token):
        return self.android_messages_proxy.listConversationsEnd(token)

    def listMessagesBegin(self, conversationId):
        return self.android_messages_proxy.listMessagesBegin(conversationId)

    def listMessagesNextPage(self, token):
        return self.android_messages_proxy.listMessagesNextPage(token)

    def listMessagesEnd(self, token):
        return self.android_messages_proxy.listMessagesEnd(token)

    def sendMessage(self, number, text):
        self.android_messages_proxy.sendMessage(number, text)

    def markSMSAsRead(self, ids):
        self.android_messages_proxy.markSMSAsRead(ids)

    def messageReceived(self, message):
        pass

    def getUnreadMessages(self):
        unreadMessages = []
        conversationToken = self.listConversationsBegin()
        conversations = self.listConversationsNextPage(conversationToken)
        while conversations:
            for conversation in conversations:
                # check if conversation is read
                if conversation[5] == True:
                    continue
                messageToken = self.listMessagesBegin(conversation[0])
                messages = self.listMessagesNextPage(messageToken)
                while messages:
                    for message in messages:
                        # skip read messages
                        if message[3] == True:
                            continue
                        unreadMessages.append(message)
                    messages = self.listMessagesNextPage(messageToken)
            conversations = self.listConversationsNextPage(conversationToken)
        return unreadMessages

