#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2011-2012 Canonical, Ltd.
#
# Authors:
#  Tiago Salem Herrmann <tiago.herrmann@canonical.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import logging
import sys
import os
import dbus

logger = logging.getLogger('UfA.AndroidContacts')

# TODO: we dont currently update contacts as the current
# android service implementation refreshes everything
# when a single contact is changed. Changes to a contact
# must be tracked in the future when the service supports that.
class AndroidContacts():

    def __init__(self):
        self.bus = dbus.SessionBus()
        self.init_android_contacts_proxy()

    def unregister_from_dbus(self):
        self.bus.remove_signal_receiver(self.contacts_got_signal_owner_changed, 'NameOwnerChanged', 'org.freedesktop.DBus')

    def connect_android_contacts_bus(self):
        try:
            android_object = self.bus.get_object('com.canonical.Android',
                                                    '/com/canonical/android/contacts/Contacts')
            self.android_contacts_proxy = dbus.Interface(android_object,
                                                    'com.canonical.android.contacts.Contacts')

        except:
            # bus not available yet
            pass

    def init_android_contacts_proxy(self):
        self.connect_android_contacts_bus()
        self.bus.add_signal_receiver(self.contacts_got_signal_owner_changed, 'NameOwnerChanged', 'org.freedesktop.DBus', arg0='com.canonical.Android')

    def contacts_got_signal_owner_changed(self, name, old_owner, new_owner):
        if name == 'com.canonical.Android':
            if len(new_owner) != 0:
                self.connect_android_contacts_bus()

    def getContactForNumber(self, phoneNumber):
        return self.android_contacts_proxy.getContactForNumber(phoneNumber)

