/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 
File Name:          PromptInfo.c

Description:

Environment (opt):
 
Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================
  
  =====================================================================
****************************************************************************/


#include <string.h>
#include <stdio.h>
#include "InfoMgmt/InfoBase.h"
#include "InfoMgmt/InfoMgmt.h"
#include "GUI/error.h"

/* Description: Get the PromptDays info from config file
 * Module: Prompt Info
 * Parameter: pdays (the day number which we need)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
static int PromptInfo_GetPromptDays(char *pdays)
{
	/*parameter validity check*/
	if(pdays == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	return Ini_ReadString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, DEFAULT_PROMPTDAYS, pdays, get_tcagentconfig_path());
}


/* Description: Set the PromptDays info into config file
 * Module: Prompt Info
 * Parameter: pdays (the day number which we will set)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
static int PromptInfo_SetPromptDays(char *pdays)
{
	/*parameter validity check*/
	if(pdays == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	return Ini_WriteString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, pdays, get_tcagentconfig_path());
}

/* Description: Get the PromptTimes info from config file
 * Module: Prompt Info
 * Parameter: ptimes (the times number which we need)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
static int PromptInfo_GetPromptTimes(char *ptimes)
{
	/*parameter validity check*/
	if(ptimes == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	return Ini_ReadString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, DEFAULT_PROMPTTIMES, ptimes, get_tcagentconfig_path());
}

/* Description: Set the PromptTimes info into config file
 * Module: Prompt Info
 * Parameter: ptimes (the times number which we will set)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
static int PromptInfo_SetPromptTimes(char *ptimes)
{
	/*parameter validity check*/
	if(ptimes == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	return Ini_WriteString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, ptimes, get_tcagentconfig_path());
}

/* Description: PromptTimes Operation
 * Module: Prompt Info
 * Parameter: ptimes (the PromptTimes Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
int PromptInfo_PromptTimes(char *ptimes, char *cmd)
{
	/*parameter validity check*/
	if(ptimes == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, DEFAULT_PROMPTTIMES, ptimes, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, ptimes, get_tcagentconfig_path());
	else
	{
		WriteLog(INFOMGMT_ERR_INVALIDCMD);
		return INFOMGMT_ERR_INVALIDCMD;
	}
}

/* Description: PromptDays Operation
 * Module: Prompt Info
 * Parameter: pdays (the PromptDays Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
int PromptInfo_PromptDays(char *pdays, char *cmd)
{
	/*parameter validity check*/
	if(pdays == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, DEFAULT_PROMPTDAYS, pdays, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, pdays, get_tcagentconfig_path());
	else
	{
		WriteLog(INFOMGMT_ERR_INVALIDCMD);
		return INFOMGMT_ERR_INVALIDCMD;
	}
}


/* Description: Construct Prompt info from config file
 * Module: Prompt Info
 * Parameter: pPI (the PromptInfo structure which we need)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
int PromptInfo_Construct(PromptInfo *pPI)
{
	int ret = 0, err = 0;

	/*parameter validity check*/
	if(pPI == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	if(ret = Ini_ReadString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, DEFAULT_PROMPTDAYS, pPI->PromptDays, get_tcagentconfig_path()))
		err = ret;
	if(ret = Ini_ReadString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, DEFAULT_PROMPTTIMES, pPI->PromptTimes, get_tcagentconfig_path()))
		err = ret;
	if(err)
	{
		WriteLog(INFOMGMT_ERR_PROMPTINFO);
		return INFOMGMT_ERR_PROMPTINFO;
	}
	//else
	//	return 0;
        
	//add by xu jun
        //int prompt_days = atoi(pPI->PromptDays); //here maybe a proble. the length of this string
 	//printf("************** %d, %d ----------------", atoi(pPI->PromptDays), atoi(pPI->PromptTimes)); //no define of error
        if(strlen(pPI->PromptDays) > 2 || pPI->PromptDays[0] == '-') // overload, minus data
	{
		strcpy(pPI->PromptDays, MAX_PROMPTDAYS);
		Ini_WriteString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, MAX_PROMPTDAYS, get_tcagentconfig_path());
		WriteLog( INFOMGMT_ERR_OTHERINFO);
	}
	else if( atoi(pPI->PromptDays) == 0)     // '0', non-numerical
	{
		strcpy(pPI->PromptDays, MAX_PROMPTDAYS);
		Ini_WriteString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, MAX_PROMPTDAYS, get_tcagentconfig_path());
		WriteLog( INFOMGMT_ERR_OTHERINFO);
	}
	else if( atoi( MAX_PROMPTDAYS ) < atoi( pPI->PromptDays) )
	{
		strcpy(pPI->PromptDays, MAX_PROMPTDAYS);
		Ini_WriteString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, MAX_PROMPTDAYS, get_tcagentconfig_path());
		WriteLog( INFOMGMT_ERR_OTHERINFO);
	}

        if(strlen(pPI->PromptTimes) > 3 || pPI->PromptTimes[0] == '-') // overload, minus data
	{
		strcpy(pPI->PromptTimes, MAX_PROMPTTIMES);
		Ini_WriteString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, MAX_PROMPTTIMES, get_tcagentconfig_path());
		WriteLog( INFOMGMT_ERR_OTHERINFO);
	}
	else if( atoi(pPI->PromptTimes) == 0)     // '0', non-numerical
	{
		strcpy(pPI->PromptTimes, MAX_PROMPTTIMES);
		Ini_WriteString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, MAX_PROMPTTIMES, get_tcagentconfig_path());
		WriteLog( INFOMGMT_ERR_OTHERINFO);
	}
	else if( atoi(MAX_PROMPTTIMES) < atoi(pPI->PromptTimes) )
	{
		strcpy(pPI->PromptTimes, MAX_PROMPTTIMES);
		Ini_WriteString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, MAX_PROMPTTIMES, get_tcagentconfig_path());
		WriteLog( INFOMGMT_ERR_OTHERINFO);
	}
	
	return 0;

	//end add
}

/* Description: Set the PromptDays info into config file
 * Module: Prompt Info
 * Parameter: pPI
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/
int PromptInfo_SetInfo(PromptInfo *pPI)
{
	int ret, err = 0;
	memset(pPI, 0, sizeof(PromptInfo));
	if(ret = Ini_WriteString(PROMPTINFO_SECTION, PROMPTDAYS_VALUE, pPI->PromptDays, get_tcagentconfig_path()))
	{        
#ifdef DEBUG             
printf("PromptInfoErrno1: %d\n", ret); 
#endif
		err = ret;
	}		
	
	if(ret = Ini_WriteString(PROMPTINFO_SECTION, PROMPTTIMES_VALUE, pPI->PromptTimes, get_tcagentconfig_path()))
	{        
#ifdef DEBUG             
printf("PromptInfoErrno2: %d\n", ret); 
#endif
		err = ret;			
	}

	if(err)
	{
		WriteLog(INFOMGMT_ERR_PROMPTINFO);
		return INFOMGMT_ERR_PROMPTINFO;	
	}
	else
		return 0;
}

