--TEST--
mysqli_real_escape_string() - euckr
--SKIPIF--
<?php
if (ini_get('unicode.semantics'))
	die("skip Test cannot be run in unicode mode");

require_once('skipif.inc');
require_once('skipifemb.inc');
require_once('skipifconnectfailure.inc');
require_once('connect.inc');

if (!$link = mysqli_connect($host, $user, $passwd, $db, $port, $socket)) {
	die(sprintf("skip Cannot connect to MySQL, [%d] %s\n",
		mysqli_connect_errno(), mysqli_connect_error()));
}
if (!mysqli_set_charset($link, 'euckr'))
	die(sprintf("skip Cannot set charset 'euckr'"));
mysqli_close($link);
?>
--FILE--
<?php
	require_once("connect.inc");
	require_once('table.inc');

	var_dump(mysqli_set_charset($link, "euckr"));

	if ('Ǵ뼺\\\\Ǵ뼺' !== ($tmp = mysqli_real_escape_string($link, 'Ǵ뼺\\Ǵ뼺')))
		printf("[004] Expecting \\\\, got %s\n", $tmp);

	if ('Ǵ뼺\"Ǵ뼺' !== ($tmp = mysqli_real_escape_string($link, 'Ǵ뼺"Ǵ뼺')))
		printf("[005] Expecting \", got %s\n", $tmp);

	if ("Ǵ뼺\'Ǵ뼺" !== ($tmp = mysqli_real_escape_string($link, "Ǵ뼺'Ǵ뼺")))
		printf("[006] Expecting ', got %s\n", $tmp);

	if ("Ǵ뼺\\nǴ뼺" !== ($tmp = mysqli_real_escape_string($link, "Ǵ뼺\nǴ뼺")))
		printf("[007] Expecting \\n, got %s\n", $tmp);

	if ("Ǵ뼺\\rǴ뼺" !== ($tmp = mysqli_real_escape_string($link, "Ǵ뼺\rǴ뼺")))
		printf("[008] Expecting \\r, got %s\n", $tmp);

	if ("Ǵ뼺\\0Ǵ뼺" !== ($tmp = mysqli_real_escape_string($link, "Ǵ뼺" . chr(0) . "Ǵ뼺")))
		printf("[009] Expecting %s, got %s\n", "Ǵ뼺\\0Ǵ뼺", $tmp);

	var_dump(mysqli_query($link, "INSERT INTO test(id, label) VALUES (100, '')"));

	mysqli_close($link);
	print "done!";
?>
--EXPECTF--
bool(true)
bool(true)
done!
