#!/bin/bash
set -xe

[ ! -f "/usr/share/volatile/common.sh" ] && \
    echo "Not found common.sh library."

# shellcheck source=/dev/null
. /usr/share/volatile/common.sh

volatile_task_start "casper"
ret="$?"

if [ "$ret" -eq 0 ]; then
    echo "$0 completed."
elif [ "$ret" -eq 1 ]; then
    echo "$0 not need to be executed."
else
    echo "$0 got error ($ret)."
fi

exit "$ret"
