#!/usr/bin/env bash

FIXES=(
    "debian/control"
    "s|linux-generic-hwe-24.04|linux-oem-24.04c|"
    "s|OEM-Kernel-Flavour: default|OEM-Kernel-Flavour: oem|"
    "debian/tests/meta"
    "s|linux-generic-hwe-24.04|linux-oem-24.04c|"
    "s|GRUB_FLAVOUR_ORDER=generic|GRUB_FLAVOUR_ORDER=oem|"
)

apply_fixes() {
    local i=0 file
    while [ $i -lt ${#FIXES[@]} ]; do
        file="${FIXES[$i]}"
        i=$((i + 1))

        while [[ "${FIXES[$i]}" =~ ^s\|.*$ ]]; do
            sed -i "${FIXES[$i]}" "$file"
            i=$((i + 1))
        done
    done
}

apply_fixes
dch -i "Fix Linux kernel metapackage dependency" --distribution noble
git commit -am "fix(kernel): use linux-oem-24.04c"
