#!/bin/bash
# This script is used to enable the power-saving mode of all of the Wi-Fi, audio, SATA, PCI and USB devices.
# The original state is kept in /usr/share/oem-power-consumption/ folder.

BKEEP="/usr/share/oem-power-consumption"
for file in wifi audio sata pci usb
do
    rm -irf ${BKEEP}/${file}
done

# Wi-Fi
wlanif=`iwconfig 2>/dev/null| awk '/802.11/{print $1}'`
echo ${wlanif} > ${BKEEP}/wifi
iw dev ${wlanif} set power_save on

# Audio
if test -e /sys/module/snd_hda_intel/parameters/power_save ; then
  audioStat=`cat /sys/module/snd_hda_intel/parameters/power_save`
  if test ${audioStat} != "1" ; then
      echo ${audioStat} >  ${BKEEP}/audio
      echo '1' > '/sys/module/snd_hda_intel/parameters/power_save';
  fi
fi

# SATA 
for sataif in `ls /sys/class/scsi_host/`
do
    if test -e /sys/class/scsi_host/${sataif}/link_power_management_policy ; then
        sataStat=`cat /sys/class/scsi_host/${sataif}/link_power_management_policy`
        if test "${sataStat}" != "min_power" ; then
            echo ${sataif} ${sataStat} >> ${BKEEP}/sata
            echo 'min_power' > '/sys/class/scsi_host/'${sataif}'/link_power_management_policy'
        fi
    fi
done

# PCI
for pciif in `lspci -n | awk '{print $1}'`
do
    pciStat=`cat /sys/bus/pci/devices/0000:${pciif}/power/control`
    if test "${pciStat}" != "auto"; then
        echo ${pciif} ${pciStat} >> ${BKEEP}/pci
        echo auto > /sys/bus/pci/devices/0000:${pciif}/power/control
    fi
done


# USB
for usbif in `ls /sys/bus/usb/devices | grep -v ':'`
do
    usbStat=`cat /sys/bus/usb/devices/${usbif}/power/control`
    if test ${usbStat} != "auto"; then
        # Because a kernel bug, if all USB devices are in autosuspend, the CPU usage of the kworker process will be 99%. Here, we don't set vendor=8087 devices to autosuspend mode.. 
        vendor=`cat /sys/bus/usb/devices/${usbif}/idVendor`
        if test "${vendor}" != "8087"; then
            echo ${usbif} ${usbStat} >> ${BKEEP}/usb
            echo auto > /sys/bus/usb/devices/${usbif}/power/control
        fi
    fi
done
