#!/bin/sh

set -x

HAS_GPS=`lsusb | grep -e "2c7c:0125"`

# Check if Quectel EG25-G is available
if [ ! -z "$HAS_GPS" ]; then
    # Enable PPS
    if [ -f "/sys/class/ptp/ptp1/pps_enable" ]; then
        echo 1 > /sys/class/ptp/ptp1/pps_enable
    else
        echo 1 > /sys/class/ptp/ptp0/pps_enable
    fi

    # Quectel_WCDMA&LTE_Linux_USB_Driver_User_Guide_V1.8.pdf
    #  ttyUSB1: For GPS NMEA message output
    #  ttyUSB2: For AT command communication
    # Quectel_LTE_Standard_GNSS_Application_Note_V1.2.pdf
    #  Turn on GNSS: AT+QGPS=1
    #  Turn off GNSS: AT+QGPSEND
    echo -n -e "AT+QGPS=1\r\n" > /dev/ttyUSB2
fi
