/* mpris2-watcher.c generated by valac 0.14.2, the Vala compiler
 * generated from mpris2-watcher.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/tree.h>


#define TYPE_MPRIS2_WATCHER (mpris2_watcher_get_type ())
#define MPRIS2_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_WATCHER, Mpris2Watcher))
#define MPRIS2_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_WATCHER, Mpris2WatcherClass))
#define IS_MPRIS2_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_WATCHER))
#define IS_MPRIS2_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_WATCHER))
#define MPRIS2_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_WATCHER, Mpris2WatcherClass))

typedef struct _Mpris2Watcher Mpris2Watcher;
typedef struct _Mpris2WatcherClass Mpris2WatcherClass;
typedef struct _Mpris2WatcherPrivate Mpris2WatcherPrivate;

#define TYPE_FREE_DESKTOP_OBJECT (free_desktop_object_get_type ())
#define FREE_DESKTOP_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_OBJECT, FreeDesktopObject))
#define IS_FREE_DESKTOP_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_OBJECT))
#define FREE_DESKTOP_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_OBJECT, FreeDesktopObjectIface))

typedef struct _FreeDesktopObject FreeDesktopObject;
typedef struct _FreeDesktopObjectIface FreeDesktopObjectIface;

#define TYPE_FREE_DESKTOP_OBJECT_PROXY (free_desktop_object_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MPRIS_ROOT (mpris_root_get_type ())
#define MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_ROOT, MprisRoot))
#define IS_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_ROOT))
#define MPRIS_ROOT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_ROOT, MprisRootIface))

typedef struct _MprisRoot MprisRoot;
typedef struct _MprisRootIface MprisRootIface;

#define TYPE_MPRIS_ROOT_PROXY (mpris_root_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Mpris2WatcherCheckForActiveClientsData Mpris2WatcherCheckForActiveClientsData;

#define TYPE_FREE_DESKTOP_INTROSPECTABLE (free_desktop_introspectable_get_type ())
#define FREE_DESKTOP_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE, FreeDesktopIntrospectable))
#define IS_FREE_DESKTOP_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE))
#define FREE_DESKTOP_INTROSPECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE, FreeDesktopIntrospectableIface))

typedef struct _FreeDesktopIntrospectable FreeDesktopIntrospectable;
typedef struct _FreeDesktopIntrospectableIface FreeDesktopIntrospectableIface;

#define TYPE_FREE_DESKTOP_INTROSPECTABLE_PROXY (free_desktop_introspectable_proxy_get_type ())

struct _Mpris2Watcher {
	GObject parent_instance;
	Mpris2WatcherPrivate * priv;
};

struct _Mpris2WatcherClass {
	GObjectClass parent_class;
};

struct _FreeDesktopObjectIface {
	GTypeInterface parent_iface;
	void (*list_names) (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _Mpris2WatcherPrivate {
	FreeDesktopObject* fdesktop_obj;
};

struct _MprisRootIface {
	GTypeInterface parent_iface;
	void (*Quit) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Quit_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	void (*Raise) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Raise_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_HasTracklist) (MprisRoot* self);
	void (*set_HasTracklist) (MprisRoot* self, gboolean value);
	gboolean (*get_CanQuit) (MprisRoot* self);
	void (*set_CanQuit) (MprisRoot* self, gboolean value);
	gboolean (*get_CanRaise) (MprisRoot* self);
	void (*set_CanRaise) (MprisRoot* self, gboolean value);
	gchar* (*get_Identity) (MprisRoot* self);
	void (*set_Identity) (MprisRoot* self, const gchar* value);
	gchar* (*get_DesktopEntry) (MprisRoot* self);
	void (*set_DesktopEntry) (MprisRoot* self, const gchar* value);
};

struct _Mpris2WatcherCheckForActiveClientsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Mpris2Watcher* self;
	gchar** interfaces;
	gint interfaces_length1;
	gint _interfaces_size_;
	FreeDesktopObject* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** address_collection;
	gint address_collection_length1;
	gint _address_collection_size_;
	gint address_it;
	gchar* _tmp7_;
	gchar* address;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	MprisRoot* _tmp11_;
	MprisRoot* mpris2_root;
	MprisRoot* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean use_playlists;
	MprisRoot* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	GError * _inner_error_;
};

struct _FreeDesktopIntrospectableIface {
	GTypeInterface parent_iface;
	gchar* (*Introspect) (FreeDesktopIntrospectable* self, GError** error);
};


static gpointer mpris2_watcher_parent_class = NULL;

GType mpris2_watcher_get_type (void) G_GNUC_CONST;
GType free_desktop_object_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_object_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_object_get_type (void) G_GNUC_CONST;
#define MPRIS2_WATCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MPRIS2_WATCHER, Mpris2WatcherPrivate))
enum  {
	MPRIS2_WATCHER_DUMMY_PROPERTY
};
Mpris2Watcher* mpris2_watcher_new (void);
Mpris2Watcher* mpris2_watcher_construct (GType object_type);
static void mpris2_watcher_check_for_active_clients_data_free (gpointer _data);
void mpris2_watcher_check_for_active_clients (Mpris2Watcher* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris2_watcher_check_for_active_clients_finish (Mpris2Watcher* self, GAsyncResult* _res_);
static gboolean mpris2_watcher_check_for_active_clients_co (Mpris2WatcherCheckForActiveClientsData* _data_);
void free_desktop_object_list_names (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** free_desktop_object_list_names_finish (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void mpris2_watcher_check_for_active_clients_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define MPRIS_PREFIX "org.mpris.MediaPlayer2."
GType mpris_root_proxy_get_type (void) G_GNUC_CONST;
guint mpris_root_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_root_get_type (void) G_GNUC_CONST;
static MprisRoot* mpris2_watcher_create_mpris_root (Mpris2Watcher* self, const gchar* name);
static gboolean mpris2_watcher_supports_playlists (Mpris2Watcher* self, const gchar* name);
gchar* mpris_root_get_DesktopEntry (MprisRoot* self);
static void mpris2_watcher_name_changes_detected (Mpris2Watcher* self, FreeDesktopObject* dbus_obj, const gchar* name, const gchar* previous_owner, const gchar* current_owner);
#define MPRIS_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
GType free_desktop_introspectable_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_introspectable_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_introspectable_get_type (void) G_GNUC_CONST;
gchar* free_desktop_introspectable_Introspect (FreeDesktopIntrospectable* self, GError** error);
static gboolean mpris2_watcher_parse_interfaces (Mpris2Watcher* self, const gchar* interface_info);
static void g_cclosure_user_marshal_VOID__STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * mpris2_watcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define FREEDESKTOP_SERVICE "org.freedesktop.DBus"
#define FREEDESKTOP_OBJECT "/org/freedesktop/DBus"
static void _mpris2_watcher_name_changes_detected_free_desktop_object_name_owner_changed (FreeDesktopObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self);
static void mpris2_watcher_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Mpris2Watcher* mpris2_watcher_construct (GType object_type) {
	Mpris2Watcher * self = NULL;
	self = (Mpris2Watcher*) g_object_new (object_type, NULL);
	return self;
}


Mpris2Watcher* mpris2_watcher_new (void) {
	return mpris2_watcher_construct (TYPE_MPRIS2_WATCHER);
}


static void mpris2_watcher_check_for_active_clients_data_free (gpointer _data) {
	Mpris2WatcherCheckForActiveClientsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Mpris2WatcherCheckForActiveClientsData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void mpris2_watcher_check_for_active_clients (Mpris2Watcher* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Mpris2WatcherCheckForActiveClientsData* _data_;
	Mpris2Watcher* _tmp0_;
	_data_ = g_slice_new0 (Mpris2WatcherCheckForActiveClientsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, mpris2_watcher_check_for_active_clients);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, mpris2_watcher_check_for_active_clients_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mpris2_watcher_check_for_active_clients_co (_data_);
}


void mpris2_watcher_check_for_active_clients_finish (Mpris2Watcher* self, GAsyncResult* _res_) {
	Mpris2WatcherCheckForActiveClientsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void mpris2_watcher_check_for_active_clients_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	Mpris2WatcherCheckForActiveClientsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mpris2_watcher_check_for_active_clients_co (_data_);
}


static gboolean mpris2_watcher_check_for_active_clients_co (Mpris2WatcherCheckForActiveClientsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->interfaces_length1 = 0;
	_data_->_interfaces_size_ = 0;
	{
		_data_->_tmp0_ = _data_->self->priv->fdesktop_obj;
		_data_->_tmp1_ = 0;
		_data_->_state_ = 1;
		free_desktop_object_list_names (_data_->_tmp0_, mpris2_watcher_check_for_active_clients_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = free_desktop_object_list_names_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp3__length1 = _data_->_tmp1_;
		_data_->__tmp3__size_ = _data_->_tmp3__length1;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch8_g_io_error;
			}
			_data_->interfaces = (_vala_array_free (_data_->interfaces, _data_->interfaces_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->interfaces = (_vala_array_free (_data_->interfaces, _data_->interfaces_length1, (GDestroyNotify) g_free), NULL);
		_data_->interfaces = _data_->_tmp3_;
		_data_->interfaces_length1 = _data_->_tmp3__length1;
		_data_->_interfaces_size_ = _data_->interfaces_length1;
	}
	goto __finally8;
	__catch8_g_io_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("mpris2-watcher.vala:60: Mpris2watcher could fetch active interfaces at" \
" startup: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
		_data_->interfaces = (_vala_array_free (_data_->interfaces, _data_->interfaces_length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally8:
	if (_data_->_inner_error_ != NULL) {
		_data_->interfaces = (_vala_array_free (_data_->interfaces, _data_->interfaces_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->interfaces;
	_data_->_tmp6__length1 = _data_->interfaces_length1;
	{
		_data_->address_collection_length1 = 0;
		_data_->_address_collection_size_ = 0;
		_data_->address_collection = _data_->_tmp6_;
		_data_->address_collection_length1 = _data_->_tmp6__length1;
		_data_->address_it = 0;
		for (_data_->address_it = 0; _data_->address_it < _data_->_tmp6__length1; _data_->address_it = _data_->address_it + 1) {
			_data_->_tmp7_ = g_strdup (_data_->address_collection[_data_->address_it]);
			_data_->address = _data_->_tmp7_;
			{
				_data_->_tmp8_ = _data_->address;
				_data_->_tmp9_ = FALSE;
				_data_->_tmp9_ = g_str_has_prefix (_data_->_tmp8_, MPRIS_PREFIX);
				if (_data_->_tmp9_) {
					_data_->_tmp10_ = _data_->address;
					_data_->_tmp11_ = NULL;
					_data_->_tmp11_ = mpris2_watcher_create_mpris_root (_data_->self, _data_->_tmp10_);
					_data_->mpris2_root = _data_->_tmp11_;
					_data_->_tmp12_ = _data_->mpris2_root;
					if (_data_->_tmp12_ == NULL) {
						_g_object_unref0 (_data_->mpris2_root);
						_g_free0 (_data_->address);
						_data_->interfaces = (_vala_array_free (_data_->interfaces, _data_->interfaces_length1, (GDestroyNotify) g_free), NULL);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp13_ = _data_->address;
					_data_->_tmp14_ = FALSE;
					_data_->_tmp14_ = mpris2_watcher_supports_playlists (_data_->self, _data_->_tmp13_);
					_data_->use_playlists = _data_->_tmp14_;
					_data_->_tmp15_ = _data_->mpris2_root;
					_data_->_tmp16_ = mpris_root_get_DesktopEntry (_data_->_tmp15_);
					_data_->_tmp17_ = _data_->_tmp16_;
					_data_->_tmp18_ = _data_->_tmp17_;
					_data_->_tmp19_ = _data_->address;
					_data_->_tmp20_ = _data_->use_playlists;
					g_signal_emit_by_name (_data_->self, "client-appeared", _data_->_tmp18_, _data_->_tmp19_, _data_->_tmp20_);
					_g_free0 (_data_->_tmp18_);
					_g_object_unref0 (_data_->mpris2_root);
				}
				_g_free0 (_data_->address);
			}
		}
	}
	_data_->interfaces = (_vala_array_free (_data_->interfaces, _data_->interfaces_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void mpris2_watcher_name_changes_detected (Mpris2Watcher* self, FreeDesktopObject* dbus_obj, const gchar* name, const gchar* previous_owner, const gchar* current_owner) {
	const gchar* _tmp0_;
	MprisRoot* _tmp1_ = NULL;
	MprisRoot* mpris2_root;
	MprisRoot* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (previous_owner != NULL);
	g_return_if_fail (current_owner != NULL);
	_tmp0_ = name;
	_tmp1_ = mpris2_watcher_create_mpris_root (self, _tmp0_);
	mpris2_root = _tmp1_;
	_tmp2_ = mpris2_root;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (mpris2_root);
		return;
	}
	_tmp4_ = previous_owner;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		const gchar* _tmp5_;
		_tmp5_ = current_owner;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = name;
		g_debug ("mpris2-watcher.vala:84: Client '%s' gone down", _tmp7_);
		_tmp8_ = name;
		g_signal_emit_by_name (self, "client-disappeared", _tmp8_);
	} else {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		gboolean _tmp12_;
		_tmp10_ = previous_owner;
		if (g_strcmp0 (_tmp10_, "") == 0) {
			const gchar* _tmp11_;
			_tmp11_ = current_owner;
			_tmp9_ = g_strcmp0 (_tmp11_, "") != 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp12_ = _tmp9_;
		if (_tmp12_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gboolean _tmp15_ = FALSE;
			gboolean use_playlists;
			MprisRoot* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp13_ = name;
			g_debug ("mpris2-watcher.vala:88: Client '%s' has appeared", _tmp13_);
			_tmp14_ = name;
			_tmp15_ = mpris2_watcher_supports_playlists (self, _tmp14_);
			use_playlists = _tmp15_;
			_tmp16_ = mpris2_root;
			_tmp17_ = mpris_root_get_DesktopEntry (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp20_ = name;
			_tmp21_ = use_playlists;
			g_signal_emit_by_name (self, "client-appeared", _tmp19_, _tmp20_, _tmp21_);
			_g_free0 (_tmp19_);
		}
	}
	_g_object_unref0 (mpris2_root);
}


static MprisRoot* mpris2_watcher_create_mpris_root (Mpris2Watcher* self, const gchar* name) {
	MprisRoot* result = NULL;
	MprisRoot* mpris2_root;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	mpris2_root = NULL;
	_tmp0_ = name;
	_tmp1_ = g_str_has_prefix (_tmp0_, MPRIS_PREFIX);
	if (_tmp1_) {
		{
			const gchar* _tmp2_;
			MprisRoot* _tmp3_ = NULL;
			MprisRoot* _tmp4_;
			_tmp2_ = name;
			_tmp3_ = g_initable_new (TYPE_MPRIS_ROOT_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp2_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", MPRIS_MEDIA_PLAYER_PATH, "g-interface-name", "org.mpris.MediaPlayer2", NULL);
			_tmp4_ = (MprisRoot*) _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch9_g_io_error;
				}
				_g_object_unref0 (mpris2_root);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (mpris2_root);
			mpris2_root = _tmp4_;
		}
		goto __finally9;
		__catch9_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("mpris2-watcher.vala:103: Mpris2watcher could not create a root interfa" \
"ce: %s", _tmp6_);
			_g_error_free0 (e);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (mpris2_root);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = mpris2_root;
	return result;
}


static gboolean mpris2_watcher_supports_playlists (Mpris2Watcher* self, const gchar* name) {
	gboolean result = FALSE;
	FreeDesktopIntrospectable* introspectable = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		const gchar* _tmp0_;
		FreeDesktopIntrospectable* _tmp1_ = NULL;
		FreeDesktopIntrospectable* _tmp2_;
		FreeDesktopIntrospectable* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* results;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp0_ = name;
		_tmp1_ = g_initable_new (TYPE_FREE_DESKTOP_INTROSPECTABLE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", _tmp0_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", MPRIS_MEDIA_PLAYER_PATH, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
		_tmp2_ = (FreeDesktopIntrospectable*) _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch10_g_io_error;
			}
			_g_object_unref0 (introspectable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (introspectable);
		introspectable = _tmp2_;
		_tmp3_ = introspectable;
		_tmp4_ = free_desktop_introspectable_Introspect (_tmp3_, &_inner_error_);
		results = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch10_g_io_error;
			}
			_g_object_unref0 (introspectable);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp5_ = results;
		_tmp6_ = mpris2_watcher_parse_interfaces (self, _tmp5_);
		result = _tmp6_;
		_g_free0 (results);
		_g_object_unref0 (introspectable);
		return result;
	}
	goto __finally10;
	__catch10_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("mpris2-watcher.vala:131: Could not create an introspectable object: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (introspectable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_object_unref0 (introspectable);
	return result;
}


static gboolean mpris2_watcher_parse_interfaces (Mpris2Watcher* self, const gchar* interface_info) {
	gboolean result = FALSE;
	gboolean _result_;
	const gchar* _tmp0_;
	xmlDoc* _tmp1_ = NULL;
	xmlDoc* xml_doc;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlNode* _tmp4_ = NULL;
	xmlNode* root_node;
	xmlNode* _tmp5_;
	xmlDoc* _tmp27_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (interface_info != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = interface_info;
	_tmp1_ = xmlParseDoc (_tmp0_);
	xml_doc = _tmp1_;
	_tmp2_ = xml_doc;
	if (_tmp2_ == NULL) {
		g_warning ("mpris2-watcher.vala:143: Mpris2Watcher - parse-interfaces - failed to " \
"instantiate xml doc");
		result = FALSE;
		return result;
	}
	_tmp3_ = xml_doc;
	_tmp4_ = xmlDocGetRootElement (_tmp3_);
	root_node = _tmp4_;
	_tmp5_ = root_node;
	if (_tmp5_ == NULL) {
		xmlDoc* _tmp6_;
		_tmp6_ = xml_doc;
		xmlFreeDoc (_tmp6_);
		g_warning ("mpris2-watcher.vala:151: Mpris2Watcher - the interface info xml is emp" \
"ty");
		result = FALSE;
		return result;
	}
	{
		xmlNode* _tmp7_;
		xmlNode* _tmp8_;
		xmlNode* iter;
		_tmp7_ = root_node;
		_tmp8_ = _tmp7_->children;
		iter = _tmp8_;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				xmlNode* _tmp13_;
				xmlNode* _tmp14_;
				xmlElementType _tmp15_;
				xmlNode* _tmp16_;
				xmlAttr* _tmp17_;
				xmlAttr* attributes;
				xmlAttr* _tmp18_;
				xmlNode* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* interface_name;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gboolean _tmp26_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					xmlNode* _tmp11_;
					xmlNode* _tmp12_;
					_tmp11_ = iter;
					_tmp12_ = _tmp11_->next;
					iter = _tmp12_;
				}
				_tmp9_ = FALSE;
				_tmp13_ = iter;
				if (!(_tmp13_ != NULL)) {
					break;
				}
				_tmp14_ = iter;
				_tmp15_ = _tmp14_->type;
				if (_tmp15_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp16_ = iter;
				_tmp17_ = _tmp16_->properties;
				attributes = _tmp17_;
				_tmp18_ = attributes;
				_tmp19_ = _tmp18_->children;
				_tmp20_ = _tmp19_->content;
				_tmp21_ = g_strdup (_tmp20_);
				interface_name = _tmp21_;
				_tmp22_ = interface_name;
				g_debug ("mpris2-watcher.vala:163: this dbus object has interface %s ", _tmp22_);
				_tmp23_ = interface_name;
				_tmp24_ = g_strconcat (MPRIS_PREFIX, "Playlists", NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strcmp0 (_tmp23_, _tmp25_) == 0;
				_g_free0 (_tmp25_);
				if (_tmp26_) {
					_result_ = TRUE;
				}
				_g_free0 (interface_name);
			}
		}
	}
	_tmp27_ = xml_doc;
	xmlFreeDoc (_tmp27_);
	result = _result_;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_BOOLEAN) (gpointer data1, const char* arg_1, const char* arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}


static void _mpris2_watcher_name_changes_detected_free_desktop_object_name_owner_changed (FreeDesktopObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self) {
	mpris2_watcher_name_changes_detected (self, _sender, name, old_owner, new_owner);
}


static GObject * mpris2_watcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Mpris2Watcher * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (mpris2_watcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MPRIS2_WATCHER (obj);
	{
		FreeDesktopObject* _tmp0_ = NULL;
		FreeDesktopObject* _tmp1_;
		FreeDesktopObject* _tmp2_;
		_tmp0_ = g_initable_new (TYPE_FREE_DESKTOP_OBJECT_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", FREEDESKTOP_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", FREEDESKTOP_OBJECT, "g-interface-name", "org.freedesktop.DBus", NULL);
		_tmp1_ = (FreeDesktopObject*) _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch11_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->fdesktop_obj);
		self->priv->fdesktop_obj = _tmp1_;
		_tmp2_ = self->priv->fdesktop_obj;
		g_signal_connect_object (_tmp2_, "name-owner-changed", (GCallback) _mpris2_watcher_name_changes_detected_free_desktop_object_name_owner_changed, self, 0);
		mpris2_watcher_check_for_active_clients (self, NULL, NULL);
	}
	goto __finally11;
	__catch11_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("mpris2-watcher.vala:46: Mpris2watcher could not set up a watch for mpr" \
"is clients appearing on the bus: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void mpris2_watcher_class_init (Mpris2WatcherClass * klass) {
	mpris2_watcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Mpris2WatcherPrivate));
	G_OBJECT_CLASS (klass)->constructor = mpris2_watcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = mpris2_watcher_finalize;
	g_signal_new ("client_appeared", TYPE_MPRIS2_WATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_BOOLEAN, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("client_disappeared", TYPE_MPRIS2_WATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void mpris2_watcher_instance_init (Mpris2Watcher * self) {
	self->priv = MPRIS2_WATCHER_GET_PRIVATE (self);
}


static void mpris2_watcher_finalize (GObject* obj) {
	Mpris2Watcher * self;
	self = MPRIS2_WATCHER (obj);
	_g_object_unref0 (self->priv->fdesktop_obj);
	G_OBJECT_CLASS (mpris2_watcher_parent_class)->finalize (obj);
}


GType mpris2_watcher_get_type (void) {
	static volatile gsize mpris2_watcher_type_id__volatile = 0;
	if (g_once_init_enter (&mpris2_watcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Mpris2WatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mpris2_watcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mpris2Watcher), 0, (GInstanceInitFunc) mpris2_watcher_instance_init, NULL };
		GType mpris2_watcher_type_id;
		mpris2_watcher_type_id = g_type_register_static (G_TYPE_OBJECT, "Mpris2Watcher", &g_define_type_info, 0);
		g_once_init_leave (&mpris2_watcher_type_id__volatile, mpris2_watcher_type_id);
	}
	return mpris2_watcher_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



