#include "sp_timer.h"
#include "sp_key_action.h"

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include "sp_error.h"



sp_timer_t sp_timer_list[SP_TIMER_MAX];

/*
FuncName:sp_add_timer
Disp		:use the g_timeout_add,this function can give you a timer,but you must give it the correct parameter...
In		:interval: the timer interval(mill seconds) ;type:not the timer type,but which function;gdata:the data of call back
Return	:NULL
Author	:frankey
Date		:20090415
Version	:1.0
*/
void sp_add_timer(int interval,SP_TIMER which_timer,int (* back_func)(gpointer),gpointer gdata)
{
    int sp_timer_source_id = 0;
    if(which_timer < SP_TIMER_LAST && which_timer >= 0){
        sp_remove_timer(which_timer);
        sp_timer_source_id = g_timeout_add(interval, back_func, gdata);
        if(sp_timer_source_id > 0){
            sp_timer_list[which_timer].iTimerId = sp_timer_source_id;
            sp_timer_list[which_timer].iInterval = interval;
            sp_timer_list[which_timer].status = SP_TIMER_STATUS_ON;	
            sp_timer_list[which_timer].pData = gdata;
        }else{
			SP_TRACE(SP_TRACE_LEVEL_ERROR,"alloc error...",NULL);
        }
    }else{
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"can not alloc the timer of this type...",NULL);
    }
}

/*
FuncName:sp_remove_timer
Disp		:remove the timer from mainloop and then free the memory of this timer
In		:not the timer type but the countertype which used to tag this is which function timer
Return	:success:0     or failed:negative
Author	:frankey
Date		:20090415
Version	:1.0
*/
int sp_remove_timer(SP_TIMER which_timer)
{
    if(which_timer >= SP_TIMER_LAST){/*ûдTIMER*/
    	return SP_RET_FAILED;
    }
    if(sp_timer_list[which_timer].iTimerId>0){
        g_source_remove(sp_timer_list[which_timer].iTimerId);
        sp_timer_list[which_timer].pData=NULL;
        memset(&sp_timer_list[which_timer],0x00,sizeof(sp_timer_t));
        return SP_RET_SUCCESS;
    }
    return SP_RET_FAILED;
}
/*
FuncName:sp_timer_status_set
Disp		:set the status of timer according the counter type
In		:counter type && status.
Return	:False or true:.
Author	:frankey
Date		:20090421
Version	:1.0
*/
gboolean sp_timer_status_set(SP_TIMER which_timer,SP_TIMER_STATUS timer_status)
{
    if(sp_timer_list[which_timer].iTimerId<=0){
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"timer not exist",NULL);
        return FALSE;
    }
    sp_timer_list[which_timer].status=timer_status;
    return TRUE;
}
/*
FuncName:sp_timer_status_get
Disp		:get the status of timer according the counter type
In		:counter type
Return	:timer status
Author	:frankey
Date		:20090421
Version	:1.0
*/
SP_TIMER_STATUS sp_timer_status_get(SP_TIMER which_timer)
{
    if(which_timer>=SP_TIMER_LAST){
    	return 0;/*not exist*/
    }
    if(sp_timer_list[which_timer].iTimerId<=0){
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"timer not exist",NULL);
        return SP_TIMER_STATUS_OFF;
    }
    return sp_timer_list[which_timer].status;
}

