#include "sp_get_event.h"
#include "sp_key_gconf.h"
#include "sp_key_action.h"
#include "sp_timer.h"
#include "sp_error.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h> /*getopt()*/
#include <syslog.h>
#include <signal.h>
#include <string.h>

const char* program_name;
#define SP_HW_KEY_VERSION	"v005.20100507"
#define SP_LOCK_FILE "/tmp/.sp_key_action.lock"

static int sp_lock_reg(int fd, int cmd, int type, off_t offset, int whence, off_t len)
{
    struct flock lock;
    lock.l_type = type;         /* F_RDLCK,F_WRLCK,F_UNLCK */
    lock.l_start = offset;      /* byte offset,relative to l_whence */
    lock.l_whence = whence;     /* SEEK_SET,SEEK_CUR,SEEK_END */
    lock.l_len = len;           /* 0 means to EOF */
    return(fcntl(fd, cmd, &lock));
}

static int sp_daemon_lock()
{
    int lockfd;
	char *user_name = getenv("DISPLAY");
	char lock_file[512];
	if(user_name == NULL)
		sprintf(lock_file,"%s",SP_LOCK_FILE);
	else
		sprintf(lock_file,"%s.%s",SP_LOCK_FILE,user_name);
    if((lockfd = open(lock_file, O_WRONLY|O_CREAT, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)) < 0){
        fprintf(stderr, "lock file(%s) failed !\n", lock_file);
        exit(0);
        /*return SP_ERR_FILE_OPEN;*/
    }
    if(sp_lock_reg(lockfd, F_SETLK, F_WRLCK, 0, SEEK_SET, 0) < 0){
        if(errno == EACCES || errno == EAGAIN){
            fprintf(stderr, "%s is already running !\n",program_name);
            exit(0);
        }else{
            fprintf(stderr, "lock_reg error !\n");
            exit(0);
            /*return SP_ERR_FILE_LOCK;*/
        }
    }
    return SP_RET_SUCCESS;
}

int sp_daemon_init(void)
{
    pid_t pid;
    int rtn;
    if((pid = fork()) < 0)
        return(-1);
    else
        if(pid != 0)
            exit(0); /* parent exit */
    /* child continues */
    setsid(); /* become session leader */
    rtn = chdir("/"); /* change working directory */
    umask(0); /* clear file mode creation mask */
    close(0); /* close stdin */
    close(1); /* close stdout */
    close(2); /* close stderr */
    return(0);
}

void sp_sig_term(int signo)
{
    if(signo == SIGTERM)
    /* catched signal sent by kill(1) command */
    {
        syslog(LOG_INFO, "program terminated.");
        closelog();
        exit(0);
    }
}

void sp_print_usage ()
{
    fprintf(stderr, "Usage: %s [ -h | -d | -v ]\n", program_name);
    fprintf(stderr, "   -h (help)\n"
                    "   -d (daemon mode)\n"
                    "   -v (version)\n");
    fprintf(stderr, "env:\n"
                    "   export %s\n"
                    "   export %s\n"
                    "   export %s\n"
                    "   export %s\n",
                    SP_ENV_TRACE_LEVEL,
                    SP_ENV_TRACE2CONSOLE,
                    SP_ENV_TRACE_FILENAME,
                    SP_ENV_TRACE_SIZE);
    fprintf(stderr, "gconf:\n"
                    "   %s\n"
                    "   %s\n"
                    "   %s\n",
					SP_GCONF_KEY_PATH,
					SP_GCONF_ACTION_PATH,
					SP_GCONF_CONFIGURE_PATH);
}



int main(int argc, char**argv)
{
	int next_option;

	int sp_daemon_flag = 0;

    GMainLoop* loop;

    sp_iochannel sIOChannel;

    //sIOChannel = g_new0(sp_iochannel,1);

	memset(&sIOChannel,0x00,sizeof(sp_iochannel));

	program_name = argv[0];

	if(argc > 2){
        sp_print_usage();
        return 0;
    }
    while((next_option = getopt(argc, argv, "dvh")) != -1){
        switch (next_option){
            case 'd':     /* daemon */
                printf("Not Support This Function \n");
				//sp_daemon_flag = 1;	
				return SP_RET_SUCCESS;
				break;
            case 'v':     /* version */
                fprintf(stdout, "version %s.\n", SP_HW_KEY_VERSION);
                return SP_RET_SUCCESS;
                break;
            case ':':     /* no arg */
            case '?':     /* unknown */
            case 'h':     /* help */
            default:
                sp_print_usage();
                return SP_RET_SUCCESS;
            break;
        }
    }while (next_option != -1);

	printf("main function start...\n");

	sp_daemon_lock();

    if(g_thread_supported() == 0){
        g_thread_init(NULL);
    }
    g_type_init ();

	gconf_init(argc, argv, NULL);

	/*we should set the gconf value before trace init, because trace will use the gconf value*/
	sp_gconf_value_setting_init();

	{
        char buff[_MAX_PATH];
        memset(buff, 0x00, sizeof(buff));
        sprintf(buff, "%s.", SP_HW_KEY_VERSION);
        sp_trace_init(1, buff);/* 1: opening trace file when start */
   	}

	if(sp_daemon_flag == 1){
		if(sp_daemon_init() == -1) {
			SP_TRACE(SP_TRACE_LEVEL_CRITICAL, "can't fork self", NULL);
			return 0;
		}
        signal(SIGTERM, sp_sig_term); /* arrange to catch the signal */
        SP_TRACE(SP_TRACE_LEVEL_CRITICAL, "===== %s daemon starting. version %s. =====", program_name, SP_HW_KEY_VERSION);
	}
	else
		SP_TRACE(SP_TRACE_LEVEL_DEBUG, "===== %s starting. version %s. =====", program_name, SP_HW_KEY_VERSION);

	sp_gconf_init();

	memset(sp_timer_list,0,sizeof(sp_timer_t));

    sp_init_event_monitor(&sIOChannel);

    loop = g_main_loop_new(NULL, FALSE);

    g_main_loop_run(loop);

    //g_free(sIOChannel);

	sp_trace_destroy();

    return SP_RET_SUCCESS;

}
