#ifndef _SP_KEY_GCONF_H
#define _SP_KEY_GCONF_H

#include <glib.h>
#include "sp_key_action.h"

/*the gconf value string length, currently less than 32*/
#define SP_STRING_MAX_LEN	32

/*there are 17 key compostion for you to selected*/
#define SP_GCONF_KEY_SELECTED_NUM	46	

/*key compostion gconf value path*/
#define	SP_GCONF_KEY_PATH	"/spider/key_setting" 

/*10 action key emulator string gconf value*/ 
#define	SP_GCONF_ACTION_PATH	"/spider/action_setting" 

/*some configure value such as "trace path,level,size" and "key type interval"*/
#define	SP_GCONF_CONFIGURE_PATH	"/spider/configure_setting" 

/*key composition string value*/
#define SP_GCONF_LEFT_KEY_SHORT_PRESS	SP_GCONF_KEY_PATH	"/left_key_short_press"
#define SP_GCONF_LEFT_KEY_LONG_PRESS	SP_GCONF_KEY_PATH	"/left_key_long_press"
#define SP_GCONF_RIGHT_KEY_SHORT_PRESS	SP_GCONF_KEY_PATH	"/right_key_short_press"
#define SP_GCONF_RIGHT_KEY_LONG_PRESS	SP_GCONF_KEY_PATH	"/right_key_long_press"
#define SP_GCONF_BOTH_KEY_SHORT_PRESS	SP_GCONF_KEY_PATH	"/both_key_short_press"
#define SP_GCONF_BOTH_KEY_LONG_PRESS	SP_GCONF_KEY_PATH	"/both_key_long_press"
 
/*action string value*/
#define SP_GCONF_MOUSE_LEFT_ACTION	SP_GCONF_ACTION_PATH	"/mouse_left_action"
#define SP_GCONF_MOUSE_RIGHT_ACTION	SP_GCONF_ACTION_PATH	"/mouse_right_action"
#define SP_GCONF_MOUSE_MIDDLE_ACTION	SP_GCONF_ACTION_PATH	"/mouse_middle_action"
#define SP_GCONF_ALTL_KEY_ACTION	SP_GCONF_ACTION_PATH	"/key_alt_l_ction"
#define SP_GCONF_CTRL_KEY_ACTION	SP_GCONF_ACTION_PATH	"/key_ctrl_l_action"
#define SP_GCONF_OPTICAL_POINT_ACTION	SP_GCONF_ACTION_PATH	"/optical_point_action"
#define SP_GCONF_DISPLAY_DESKTOP_ACTION	SP_GCONF_ACTION_PATH	"/display_desktop_action"
#define SP_GCONF_DEVICE_SETUP_ACTION	SP_GCONF_ACTION_PATH	"/device_setup_action"
#define SP_GCONF_SOFTWARE_KEYBOARD_ACTION	SP_GCONF_ACTION_PATH	"/software_keyboard_action"
#define SP_GCONF_RESERVED_ACTION	SP_GCONF_ACTION_PATH	"/reserved_action"
	

/*some configure value*/
#define SP_GCONF_KEY_TYPE_WAIT_TIME		SP_GCONF_CONFIGURE_PATH	"/double_key_wait_time"
#define SP_GCONF_KEY_PRESS_WAIT_TIME		SP_GCONF_CONFIGURE_PATH	"/key_long_press_need_time"
#define SP_GCONF_TRACE_PATH		SP_GCONF_CONFIGURE_PATH	"/sp_trace_path"
#define SP_GCONF_TRACE_SIZE		SP_GCONF_CONFIGURE_PATH	"/sp_trace_size"
#define SP_GCONF_TRACE_LEVEL		SP_GCONF_CONFIGURE_PATH	"/sp_trace_level"

/*gconf value setting , getting ,value modification monitor*/
void sp_gconf_init();

/*each action has 3 hotkey, this array saves the hotkey list*/
extern int sp_action_hotkey_list[SP_ACTION_LAST][3];

/*there are 17 hotkey composition can be choiced*/
typedef struct _sp_action_choice
{
	char action_choice[SP_STRING_MAX_LEN];
	int sp_x_key_value;
}s_sp_action_choice;

/*
typedef struct _sp_action_list
{
	char sp_action_item[SP_GCONF_KEY_SELECTED_NUM];
	char sp_action_string[SP_GCONF_KEY_SELECTED_NUM];
}s_sp_action_list;
*/

/*
typedef struct _sp_action_hotkey
{
	int hotkey1;
	int hotkey2;
	int hotkey3;
}s_sp_action_hotkey;
*/

/*
typedef struct _sp_key_mode
{
	char sp_gconf_key_item[SP_GCONF_KEY_SELECTED_NUM];
	int sp_key_action_num;
}s_sp_key_mode_list;
*/

#endif

