#include <gconf/gconf-client.h>
#include <X11/keysym.h>
#include "sp_error.h"

#include "sp_key_gconf.h" 
#include "sp_key_action.h"
#include "string.h"

/*
 *
 * on action has 3 hotkey. it means you can send 3 hotkey X event as action you need.
 * it be better the first 5 hotkey not changed. because it should be fixed as "mouse left, "mouse right, mouse middle, control, alt"
 *
 *
*/
int sp_action_hotkey_list[SP_ACTION_LAST][3] = 
{
1,0,0,
3,0,0,
2,0,0,
XK_Control_L,0,0,
XK_Alt_L,0,0,
/*XK_Alt_L,XK_F2,0,
XK_Alt_L,XK_F4,0,
XK_Alt_L,XK_F3,0,
XK_Alt_L,XK_F5,0,*/
XK_Ecircumflex,0,0,/*0xca*/
XK_Control_L,XK_Alt_L,XK_d,/*ctrl+alt+d*/
XK_Ediaeresis,0,0,/*0xcb*/
XK_Igrave,0,0,/*0xcc*/
0,0,0
};

/*
 *
 *there are 47 hotkey you can selected
 *
 *
*/
static s_sp_action_choice sp_action_choice_list[SP_GCONF_KEY_SELECTED_NUM] = 
{
	"mouse_left",1,
	"mouse_right",3,
	"mouse_middle",2,	
	"ctrl", XK_Control_L,
	"alt", XK_Alt_L,
    "f1",XK_F1,
    "f2",XK_F2,
    "f3",XK_F3,
    "f4",XK_F4,
    "f5",XK_F5,
    "f6",XK_F6,
    "f7",XK_F7,
    "f8",XK_F8,
    "f9",XK_F9,
    "f10",XK_F10,
    "f11",XK_F11,
    "f12",XK_F12,
	"a",XK_a,
	"b",XK_b,
	"c",XK_c,
	"d",XK_d,
	"e",XK_e,
	"f",XK_f,
	"g",XK_g,
	"h",XK_h,
	"i",XK_i,
	"j",XK_j,
	"k",XK_k,
	"l",XK_l,
	"m",XK_m,
	"n",XK_n,
	"o",XK_o,
	"p",XK_p,
	"q",XK_q,
	"r",XK_r,
	"s",XK_s,
	"t",XK_t,
	"u",XK_u,
	"v",XK_v,
	"w",XK_w,
	"x",XK_x,
	"y",XK_y,
	"z",XK_z,
	"0xca",0xCA,
	"0xcb",0xCB,
	"0xcc",0xCC,
};

/*
 *
 *you can get gconf int value by calling this function
 *
 *
*/
int sp_gconf_value_get_int(gchar *entry)
{
	GConfClient *client;

    gint key_value;

    client = gconf_client_get_default();

    gconf_client_add_dir(client,
                 SP_GCONF_KEY_PATH, GCONF_CLIENT_PRELOAD_NONE, NULL);

    key_value = gconf_client_get_int(client, entry, NULL);

	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"%s:: get gconf value %s : %d ",__func__,entry, key_value);

	return key_value;
}

/*
 *
 *you can get gconf string value by calling this function,it will return a string buffer to you to use, but you should call free if you finished using this string
 *
 *
*/
char *sp_gconf_value_get_string(gchar *entry)
{
	GConfClient *client;

	char *temp_str;

    client = gconf_client_get_default();

    gconf_client_add_dir(client,
                 SP_GCONF_ACTION_PATH, GCONF_CLIENT_PRELOAD_NONE, NULL);

    temp_str = gconf_client_get_string(client, entry, NULL);

	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"%s:: get gconf value %s : %s ",__func__,entry, temp_str);

	return temp_str;
}

/*
 *
 * after get the token gconf string such as "ctrl","alt","f2",and then find the X key value from the action choice list, in the last , we can use the index and the X key value to set the action.
 *
 *
*/
static void sp_hotkey_action_set(int index,char hotkey_str[3][SP_STRING_MAX_LEN])
{
	int i,j;
	int sp_key_code;
	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"%s:: index = %d , hotkey_str[0] = %s , hotkey_str[1] = %s, hotkey_str[2] = %s ",__func__, index, hotkey_str[0],hotkey_str[1], hotkey_str[2]);

	for(i = 0; i < 3 ; i++)
	{
		sp_action_hotkey_list[index][i] = 0x00;/*should be clear the value, or else, after you change the gconf value ,the old value is also in still in*/
		for(j = 0; (0 != strcmp(hotkey_str[i],"")) && j < SP_GCONF_KEY_SELECTED_NUM ; j++)
		{
			if(0 == strcmp(hotkey_str[i],sp_action_choice_list[j].action_choice))
			{
				switch(sp_action_choice_list[j].sp_x_key_value)
				{
					case 1:
					case 2:
					case 3:
					case 0xCA:
					case 0xCB:
					case 0xCC:
						sp_action_hotkey_list[index][i] = sp_action_choice_list[j].sp_x_key_value;/*it's key code already*/	
						break;
					default:
						sp_key_code = sp_keysym_to_keycode(sp_action_choice_list[j].sp_x_key_value);/*it's keysym, need transfer to keycode*/
						if(sp_key_code != SP_RET_FAILED)
							sp_action_hotkey_list[index][i] = sp_key_code;
						break;
				}
				break;
			}
		}
		//SP_TRACE(SP_TRACE_LEVEL_DEBUG,"hotkey_list[%d][%d] = key code = %d ",index,i,sp_action_hotkey_list[index][i]);
	}
}

/*
 *
 *separate the s_str, put the result in the str_token string array.
 *
 *
*/
static int sp_get_hotkey_string_token(char str_token[3][SP_STRING_MAX_LEN], const char *s_str)
{
	int i;
	char *needle="+";
	char source_str_array[SP_STRING_MAX_LEN];
	char *source_str = source_str_array;	
	strcpy(source_str,s_str);
	char *buf = strstr(source_str,needle);
	for(i = 0; i < 2 && buf != NULL ; i++)
	{
		buf[0] = '\0';		
		strcpy(str_token[i], source_str);
		source_str = buf + strlen(needle);
    	/* Get next token: */
		buf = strstr(source_str,needle);
	}
	strcpy(str_token[i],source_str);
   	return SP_RET_SUCCESS;
}

/*
 *
 *set the action. use a local string array to save the 9 action gconf item string. the parameter string means witch entry is changed. parameter action_str means the changed item gconf value. it will first get the index(which action) according to the parameter 1 and local string array. and then separate the action_str, for example(action_str = "ctrl+alt+f2"),after calling strstr(), then we will get "ctrl","alt","f2", after that, we can find the value in the action choice list. in the last, we can use the index and the true value to set the action changed.
 *
 *
*/
static int sp_action_setting(const gchar *string,const char *action_str)
{
	char sp_gconf_action_item[SP_ACTION_LAST][SP_STRING_MAX_LEN] = 
	{
	"mouse_left_action",
	"mouse_right_action",
	"mouse_middle_action",
	"key_alt_l_ction",
	"key_ctrl_l_action",
	"optical_point_action",
	"display_desktop_action",
	"device_setup_action",
	"software_keyboard_action",
	"reserved_action"
	};
	int i;
	int index;
	const char *item_str = NULL;
	char sp_hotkey_string[3][SP_STRING_MAX_LEN];
	memset(sp_hotkey_string,0x00,sizeof(sp_hotkey_string));
	
	int len = strlen(SP_GCONF_ACTION_PATH) + 1;/*last charactor '/' should be added*/	
	if(string == NULL || strlen(string) < len)
		return SP_RET_FAILED;
	item_str = string + len;
	for(i = 0; i < SP_ACTION_LAST; i++)
	{
		if(strcmp(sp_gconf_action_item[i] ,item_str) == 0)
		{
			index = i ;
			break;			
		}
	}

	sp_get_hotkey_string_token(sp_hotkey_string,action_str);		
	sp_hotkey_action_set(index, sp_hotkey_string);

	return SP_RET_SUCCESS;
}

/*
 *
 * get the key number about which key is changed. i use a local string array to save gconf key item. the arrangement is same with sp_key_action.
 *
 *
*/
static int sp_get_changed_key_num(const gchar *string)
{
	int i;
	const gchar *str = NULL;
	char sp_key_gconf_str[SP_KEY_MAX_COUNT][SP_STRING_MAX_LEN]=
	{
	"left_key_short_press",
	"left_key_long_press",
	"right_key_short_press",
	"right_key_long_press",
	"both_key_short_press",
	"both_key_long_press"
	};
	int len = strlen(SP_GCONF_KEY_PATH) + 1;/*last charactor '/' should be added*/	
	if(string == NULL || strlen(string) < len)
		return SP_RET_FAILED;

	str = string + len;
	for(i = 0; i < SP_KEY_MAX_COUNT ; i++ )
		if(strcmp(sp_key_gconf_str[i],str) == 0)
			break;
	return i;	
}
/*
 *
 *if action string is changed, gconf can automic calling this function to process. it will ge the changing action item, and then get witch action should be modified . finally, changed the value 
 *
 *
*/
void sp_action_value_changed_callback(GConfClient * client,
			  guint cnxn_id,
			  GConfEntry * entry, gpointer user_data)
{
	/* This will hold the pointer to the value. */
  	GConfValue* sp_gconf_value = NULL;
	const gchar *str = NULL;
	const gchar *value;
	//g_print("key_left_short_press changed");
	//str = gconf_client_get_string(client, TEST_ITEM, NULL);
	str = gconf_entry_get_key(entry);
	if(str == NULL )
	{
		SP_TRACE(SP_TRACE_LEVEL_ERROR,"couldn't get the key name ..",NULL);
		return;	
	}

  	/* Get a pointer to the value from changed entry. */
  	sp_gconf_value = gconf_entry_get_value(entry);

  	/* If we get a NULL as the value, it means that the value either has
 	*      not been set, or is at default. As a precaution we assume that
	*           this cannot ever happen, and will abort if it does.
 	*                NOTE: A real program should be more resilient in this case, but
 	*                           the problem is: what is the correct action in this case?
 	*                                      This is not always simple to decide.
 	*                                           NOTE: You can trip this assert with 'make primekeys', since that
 	*                                                      will first remove all the keys (which causes the CB to
 	*                                                                 be invoked, and abort here). */
  	//g_assert(sp_gconf_value != NULL);
	if(sp_gconf_value == NULL)
		return;

  	/* Check that it looks like a valid type for the value. */
  	if (!GCONF_VALUE_TYPE_VALID(sp_gconf_value->type)) {
		//gconf_value_free(sp_gconf_value);/*return of gconf_entry_get_value is not a copy, should not be free*/
    	//g_error(": Invalid type for gconfvalue!\n");
    	return;
  	}

	//value = gconf_value_get_int(gconf_entry_get_value(entry));
	value = gconf_value_get_string(sp_gconf_value);

	if (value != NULL) {
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"action value changed: path = %s, value = %s ", str, value);
		sp_action_setting(str,value);
	}
	else
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"key action changed: but get key error!!",NULL);

	//gconf_value_free(sp_gconf_value);/*return of gconf_entry_get_value is not a copy, should not be free*/
}

/*
 *
 *if key type gconf changed, it will auto call this function to process. this function can get the gconf changed item ,and then set the right key type according to the changing..
 *
 *
*/
void sp_key_action_changed_callback(GConfClient * client,
			  guint cnxn_id,
			  GConfEntry * entry, gpointer user_data)
{
	/* This will hold the pointer to the value. */
  	GConfValue* sp_gconf_value = NULL;
	const gchar *str = NULL;
	gint value;
	int sp_key_changed_index = -1;
	//str = gconf_client_get_string(client, TEST_ITEM, NULL);
	str = gconf_entry_get_key(entry);
	if(str == NULL )
	{
		SP_TRACE(SP_TRACE_LEVEL_ERROR,"couldn't get the key name ...",NULL);
		return;	
	}

  	/* Get a pointer to the value from changed entry. */
  	sp_gconf_value = gconf_entry_get_value(entry);

  	/* If we get a NULL as the value, it means that the value either has
 	*      not been set, or is at default. As a precaution we assume that
	*           this cannot ever happen, and will abort if it does.
 	*                NOTE: A real program should be more resilient in this case, but
 	*                           the problem is: what is the correct action in this case?
 	*                                      This is not always simple to decide.
 	*                                           NOTE: You can trip this assert with 'make primekeys', since that
 	*                                                      will first remove all the keys (which causes the CB to
 	*                                                                 be invoked, and abort here). */
  	//g_assert(sp_gconf_value != NULL);
	if(sp_gconf_value == NULL)
		return;

  	/* Check that it looks like a valid type for the value. */
  	if (!GCONF_VALUE_TYPE_VALID(sp_gconf_value->type)) {
		//gconf_value_free(sp_gconf_value); /*should not free*/
    	//g_error(": Invalid type for gconfvalue!\n");
    	return;
  	}

	//value = gconf_value_get_int(gconf_entry_get_value(entry));
	value = gconf_value_get_int(sp_gconf_value);

	if (value >= 0 && value <= 9) {
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"key action changed: path = %s, value = %d ", str, value);
		sp_key_changed_index = sp_get_changed_key_num(str);
		if( sp_key_changed_index >= KEY_LEFT_SHORT_PRESS && sp_key_changed_index <= KEY_BOTH_LONG_PRESS ) 
			sp_key_action_set(sp_key_changed_index , value);
		else
			SP_TRACE(SP_TRACE_LEVEL_DEBUG,"Error,key changed, but can't find the correct changed string....",NULL);
	}
	else
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"key action changed: but get key error!!",NULL);

	//gconf_value_free(sp_gconf_value); /*return of gconf_entry_get_value is not a copy, should not be free*/
}

/*
 *
 * monitor the gconf value ,is it is changed. then gconf can call the callback function to process the change.
 *
 *
*/
static int sp_gconf_key_value_monitor_init() 
{
	GConfClient *client;

	gint key_value;

	client = gconf_client_get_default();

	gconf_client_add_dir(client,
			     SP_GCONF_KEY_PATH, GCONF_CLIENT_PRELOAD_NONE, NULL);

	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"gconf monitor starting...",NULL);
	
	gconf_client_notify_add(client, SP_GCONF_LEFT_KEY_SHORT_PRESS,
				(GConfClientNotifyFunc)
				sp_key_action_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_LEFT_KEY_LONG_PRESS,
				(GConfClientNotifyFunc)
				sp_key_action_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_RIGHT_KEY_SHORT_PRESS,
				(GConfClientNotifyFunc)
				sp_key_action_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_RIGHT_KEY_LONG_PRESS,
				(GConfClientNotifyFunc)
				sp_key_action_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_BOTH_KEY_SHORT_PRESS,
				(GConfClientNotifyFunc)
				sp_key_action_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_BOTH_KEY_LONG_PRESS,
				(GConfClientNotifyFunc)
				sp_key_action_changed_callback, NULL, NULL, NULL);


	gconf_client_add_dir(client,
			     SP_GCONF_ACTION_PATH, GCONF_CLIENT_PRELOAD_NONE, NULL);


	gconf_client_notify_add(client, SP_GCONF_MOUSE_LEFT_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_MOUSE_RIGHT_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_MOUSE_MIDDLE_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_ALTL_KEY_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_CTRL_KEY_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client,SP_GCONF_OPTICAL_POINT_ACTION, 
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client,SP_GCONF_DISPLAY_DESKTOP_ACTION, 
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_DEVICE_SETUP_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_SOFTWARE_KEYBOARD_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	gconf_client_notify_add(client, SP_GCONF_RESERVED_ACTION,
				(GConfClientNotifyFunc)
				sp_action_value_changed_callback, NULL, NULL, NULL);

	return 0;
}

/*
 *
 *get the gconf value , it should be first to do when the program start
 *
 *
*/
static void sp_gconf_value_getting_init()
{
    GConfClient *client;

  	GConfValue* sp_gconf_value = NULL;

	gint key_value;

	gchar *hotkey_str;

    client = gconf_client_get_default();

	key_value = sp_gconf_value_get_int(SP_GCONF_LEFT_KEY_SHORT_PRESS);
	sp_key_action_set(KEY_LEFT_SHORT_PRESS,key_value);

	key_value = sp_gconf_value_get_int(SP_GCONF_LEFT_KEY_LONG_PRESS);
	sp_key_action_set(KEY_LEFT_LONG_PRESS,key_value);

	key_value = sp_gconf_value_get_int(SP_GCONF_RIGHT_KEY_SHORT_PRESS);
	sp_key_action_set(KEY_RIGHT_SHORT_PRESS,key_value);

	key_value = sp_gconf_value_get_int(SP_GCONF_RIGHT_KEY_LONG_PRESS);
	sp_key_action_set(KEY_RIGHT_LONG_PRESS,key_value);

	key_value = sp_gconf_value_get_int(SP_GCONF_BOTH_KEY_SHORT_PRESS);
	sp_key_action_set(KEY_BOTH_SHORT_PRESS,key_value);

	key_value = sp_gconf_value_get_int(SP_GCONF_BOTH_KEY_LONG_PRESS);
	sp_key_action_set(KEY_BOTH_LONG_PRESS,key_value);


	hotkey_str = sp_gconf_value_get_string(SP_GCONF_MOUSE_LEFT_ACTION);
	sp_action_setting(SP_GCONF_MOUSE_LEFT_ACTION,hotkey_str);
	g_free(hotkey_str);
	
	hotkey_str = sp_gconf_value_get_string(SP_GCONF_MOUSE_RIGHT_ACTION);
	sp_action_setting(SP_GCONF_MOUSE_RIGHT_ACTION,hotkey_str);
	g_free(hotkey_str);

	hotkey_str = sp_gconf_value_get_string(SP_GCONF_MOUSE_MIDDLE_ACTION);
	sp_action_setting(SP_GCONF_MOUSE_MIDDLE_ACTION,hotkey_str);
	g_free(hotkey_str);

	hotkey_str = sp_gconf_value_get_string(SP_GCONF_ALTL_KEY_ACTION);
	sp_action_setting(SP_GCONF_ALTL_KEY_ACTION,hotkey_str);
	g_free(hotkey_str);

	hotkey_str = sp_gconf_value_get_string(SP_GCONF_CTRL_KEY_ACTION);
	sp_action_setting(SP_GCONF_CTRL_KEY_ACTION,hotkey_str);
	g_free(hotkey_str);


	hotkey_str = sp_gconf_value_get_string(SP_GCONF_OPTICAL_POINT_ACTION);
	sp_action_setting(SP_GCONF_OPTICAL_POINT_ACTION,hotkey_str);
	g_free(hotkey_str);

	hotkey_str = sp_gconf_value_get_string(SP_GCONF_DISPLAY_DESKTOP_ACTION);
	sp_action_setting(SP_GCONF_DISPLAY_DESKTOP_ACTION,hotkey_str);
	g_free(hotkey_str);

	hotkey_str = sp_gconf_value_get_string(SP_GCONF_DEVICE_SETUP_ACTION);
	sp_action_setting(SP_GCONF_DEVICE_SETUP_ACTION,hotkey_str);
	g_free(hotkey_str);

	hotkey_str = sp_gconf_value_get_string(SP_GCONF_SOFTWARE_KEYBOARD_ACTION);
	sp_action_setting(SP_GCONF_SOFTWARE_KEYBOARD_ACTION,hotkey_str);
	g_free(hotkey_str);

	hotkey_str = sp_gconf_value_get_string(SP_GCONF_RESERVED_ACTION);
	sp_action_setting(SP_GCONF_RESERVED_ACTION,hotkey_str);
	g_free(hotkey_str);

}

/*
 *
 *
 *set action string to gconf and some configure date to gconf,if the value is in gconf, then you should not write the data again.
 *
*/
int sp_gconf_value_setting_init()
{
    GConfClient *client;

  	GConfValue* sp_gconf_value = NULL;

	gint key_value;

	gchar *hotkey_str;

    client = gconf_client_get_default();

//    gconf_client_set_int(client, SP_GCONF_MOUSE_LEFT_ACTION, 1, NULL);
   	sp_gconf_value = gconf_client_get(client,SP_GCONF_KEY_TYPE_WAIT_TIME,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_int(client, SP_GCONF_KEY_TYPE_WAIT_TIME, 300, NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_KEY_PRESS_WAIT_TIME,NULL);
	if(sp_gconf_value == NULL)	 
//    	gconf_client_set_int(client, SP_GCONF_KEY_PRESS_WAIT_TIME, 1000, NULL);
    	gconf_client_set_int(client, SP_GCONF_KEY_PRESS_WAIT_TIME, 700, NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

/* 
   	sp_gconf_value = gconf_client_get(client,SP_GCONF_TRACE_PATH,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_string(client, SP_GCONF_TRACE_PATH, "/home/sharp/_SP_TRACE", NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}
*/

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_TRACE_SIZE,NULL);
	if(sp_gconf_value == NULL)	 
//    	gconf_client_set_int(client, SP_GCONF_TRACE_SIZE, 1000, NULL);
    	gconf_client_set_int(client, SP_GCONF_TRACE_SIZE, 700, NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_TRACE_LEVEL,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_int(client, SP_GCONF_TRACE_LEVEL, 4, NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

#if 1
   	sp_gconf_value = gconf_client_get(client,SP_GCONF_MOUSE_LEFT_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_string(client, SP_GCONF_MOUSE_LEFT_ACTION, "mouse_left", NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_MOUSE_RIGHT_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_string(client, SP_GCONF_MOUSE_RIGHT_ACTION, "mouse_right", NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_MOUSE_MIDDLE_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_string(client, SP_GCONF_MOUSE_MIDDLE_ACTION, "mouse_middle", NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_ALTL_KEY_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_string(client, SP_GCONF_ALTL_KEY_ACTION, "alt", NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_CTRL_KEY_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_string(client, SP_GCONF_CTRL_KEY_ACTION, "ctrl", NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}
#endif

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_OPTICAL_POINT_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	//gconf_client_set_string(client, SP_GCONF_OPTICAL_POINT_ACTION, "alt+f2",  NULL);
    	gconf_client_set_string(client, SP_GCONF_OPTICAL_POINT_ACTION, "0xca",  NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_DISPLAY_DESKTOP_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	//gconf_client_set_string(client, SP_GCONF_CLOSE_APP_ACTION, "alt+f4",  NULL);
    	gconf_client_set_string(client, SP_GCONF_DISPLAY_DESKTOP_ACTION, "ctrl+alt+d",  NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_DEVICE_SETUP_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	//gconf_client_set_string(client, SP_GCONF_DEVICE_SETUP_ACTION, "alt+f3",  NULL);
    	gconf_client_set_string(client, SP_GCONF_DEVICE_SETUP_ACTION, "0xcb",  NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_SOFTWARE_KEYBOARD_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	//gconf_client_set_string(client, SP_GCONF_SOFTWARE_KEYBOARD_ACTION, "alt+f5",  NULL);
    	gconf_client_set_string(client, SP_GCONF_SOFTWARE_KEYBOARD_ACTION, "0xcc",  NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

   	sp_gconf_value = gconf_client_get(client,SP_GCONF_RESERVED_ACTION,NULL);
	if(sp_gconf_value == NULL)	 
    	gconf_client_set_string(client, SP_GCONF_RESERVED_ACTION, "",  NULL);
	else
	{
		gconf_value_free(sp_gconf_value);
		sp_gconf_value == NULL;
	}

    return SP_RET_SUCCESS;	
}	
/*
 *
 *init setting getting and monitor gconf value
 *
 *
*/
void sp_gconf_init()
{
	//sp_gconf_value_setting_init();
	
	sp_gconf_value_getting_init();

	sp_gconf_key_value_monitor_init();
}


