#ifndef _SP_KEY_ACTION_H
#define _SP_KEY_ACTION_H

#include "sp_get_event.h"

/*left/right key can emulate 6 compostion*/
#define SP_KEY_MAX_COUNT 	6
/*there are 10 actions when key pressed*/
#define SP_ACTION_MAX_COUNT 10


/*although there are only two keys on the device,but it can compose 6 actions by short press or release.*/
typedef enum
{
	KEY_LEFT_SHORT_PRESS,
	KEY_LEFT_LONG_PRESS,
	KEY_RIGHT_SHORT_PRESS,
	KEY_RIGHT_LONG_PRESS,
	KEY_BOTH_SHORT_PRESS,
	KEY_BOTH_LONG_PRESS,
	KEY_NONE_PRESS
}SP_KEY_MODE;

/*there are 10 actons. but the emulate keys for the actions can be defined or changed in the gconf value setting, detailed refer /spider/action_setting*/
typedef enum
{
	SP_MOUSE_LEFT_ACTION,
	SP_MOUSE_RIGHT_ACTION,
	SP_MOUSE_MIDDLE_ACTION,
	SP_KEY_ALT_ACTION,
	SP_KEY_CTRL_ACTION,
	SP_OPT_POINT_ACTION,
	SP_DISPLAY_DESKTOP_ACTION,
	SP_DEVICE_SETUP_ACTION,
	SP_SOFTWARE_KEYBOARD_ACTION,
	SP_NONE_ACTION,
	SP_ACTION_LAST
}sp_action_list;

/*send the emulate key according the 6 key composed pressed.*/
int sp_key_event_send(SP_KEY_MODE flag, SP_KEY_ACTION_TYPE key_action_type);

/*set which action will be send if some keys composition pressed*/
void sp_key_action_set(int sp_key_type, int sp_key_action);

/*transfer the keysym to keycode*/
int sp_keysym_to_keycode(int keysym);

#endif/*ifndef _SP_KEY_ACTION_H*/

