#include <X11/extensions/XTest.h>
#include <X11/keysym.h>
#include "sp_key_action.h"
#include "sp_key_gconf.h"
#include "sp_error.h"


/*default 6 key composition action,only use in this function. it can be set by sp_key_action_set function*/
static int sp_key_action[SP_KEY_MAX_COUNT]={0,5,0,1,8,9};

/*
 *
 *set sp_key_action array.
 *
 *
*/
void sp_key_action_set(int sp_key_type, int sp_action)
{
	if(sp_key_type < KEY_LEFT_SHORT_PRESS || sp_key_type > KEY_BOTH_LONG_PRESS || sp_action < SP_MOUSE_LEFT_ACTION || sp_action > SP_NONE_ACTION)
		g_print("ERROR,no this key type or action..\n");
	else
		sp_key_action[sp_key_type] = sp_action;
}

int sp_keysym_to_keycode(int keysym)
{
	int sp_key_code;
	Display* disp = XOpenDisplay( NULL );
    if( disp == NULL )
	{
		SP_TRACE(SP_TRACE_LEVEL_ERROR,"open display error...",NULL);
    	return SP_RET_FAILED;
	}
	sp_key_code = XKeysymToKeycode(disp,keysym);
	return sp_key_code;
}
	
/*
 *
 *
 *use XTest function to emulate sending event to app.
mouse press event and key event is different. mouse event use XTestFakeButtonEvent, but key event use XTestFakeKeyEvent, so they should be different trate. and because one action include 3 hotkey. and hotkey is better not be send two times(such as "alt+f3+alt", the second alt should not be send). and another attention is empty event should not be send for X. 3th parameter sp_which_event is the flag which event system will send. eg. if sp_which_event == 0, press and release event both will be send. if sp_which_event == 1, only send press event. if sp_which_event == 2, only send release event. the reson of this design is for first 5 action should only send press event when long press the button, only when the button is really released , then system just send the release event.  
 *
 *
*/
int sp_action_event_send(int which_action, int sp_which_event, Display *disp)
{
	int sp_key_code0;
	int sp_key_code1;
	int sp_key_code2;

/*
	Display* disp = XOpenDisplay( NULL );
    if( disp == NULL )
	{
		SP_TRACE(SP_TRACE_LEVEL_ERROR,"open display error...",NULL);
    	return SP_RET_FAILED;
	}
*/

	if(which_action < SP_MOUSE_LEFT_ACTION || which_action > SP_NONE_ACTION)
	{
		SP_TRACE(SP_TRACE_LEVEL_ERROR,"error, not define this event..",NULL);
		return SP_RET_FAILED;
	}
	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"send emulate event...",NULL);
	
	sp_key_code0 = sp_action_hotkey_list[which_action][0];
	sp_key_code1 = sp_action_hotkey_list[which_action][1];
	sp_key_code2 = sp_action_hotkey_list[which_action][2]; 

	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"[ hotkey0 ] : 0x%4x",sp_key_code0);
	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"[ hotkey1 ] : 0x%4x",sp_key_code1);
	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"[ hotkey2 ] : 0x%4x",sp_key_code2); 

	if(sp_which_event != 2) /* 2 means only send release event */
	{ 
		/*the first hotkey only not empty, then can be send*/
		if(sp_key_code0!= 0)	
		{
			/* if hotkey is mouse event, should be processed separately*/
			if(sp_key_code0 <= 3)
				XTestFakeButtonEvent( disp, sp_key_code0 , True, CurrentTime );/*mouse left button press*/
			else
				XTestFakeKeyEvent( disp, sp_key_code0, True, CurrentTime );
		}
		/*the second hotkey not only not empty, but also not same as first hotkey*/
		if(sp_key_code1 != 0 && sp_key_code1 != sp_key_code0)	
		{
			/* if hotkey is mouse event, should be processed separately*/
			if(sp_key_code1 <= 3)
				XTestFakeButtonEvent( disp, sp_key_code1 , True, CurrentTime );/*mouse left button press*/
			else	
				XTestFakeKeyEvent( disp, sp_key_code1, True, CurrentTime );
		}
		/*the second hotkey not only not empty, but also not same as first and second hotkey*/
		if(sp_key_code2 != 0 
				&& sp_key_code2 != sp_key_code0
				&& sp_key_code2 != sp_key_code1
			)	
		{
			/* if hotkey is mouse event, should be processed separately*/
			if(sp_key_code2 <= 3)
				XTestFakeButtonEvent( disp, sp_key_code2 , True, CurrentTime );/*mouse left button press*/
			else
				XTestFakeKeyEvent( disp, sp_key_code2, True, CurrentTime );
		}
	}
	
	if(sp_which_event != 1) /* 1 means only send press event */
	{ 
		/*key released procedure is same as pressed procedure*/
		if(sp_key_code0 != 0)	
		{
			if(sp_key_code0 <= 3)
				XTestFakeButtonEvent( disp, sp_key_code0 , False, CurrentTime );/*mouse left button press*/
			else
				XTestFakeKeyEvent( disp, sp_key_code0, False, CurrentTime );
		}
		if(sp_key_code1 != 0 && sp_key_code1 != sp_key_code0)	
		{
			if(sp_key_code1 <= 3)
				XTestFakeButtonEvent( disp, sp_key_code1 , False, CurrentTime );/*mouse left button press*/
			else
				XTestFakeKeyEvent( disp, sp_key_code1, False, CurrentTime );
		}
		if(sp_key_code2 != 0 
				&& sp_key_code2 != sp_key_code0
				&& sp_key_code2 != sp_key_code1
			)	
		{
			if(sp_key_code2 <= 3)
				XTestFakeButtonEvent( disp, sp_key_code2 , False, CurrentTime );/*mouse left button press*/
			else
				XTestFakeKeyEvent( disp, sp_key_code2, False, CurrentTime );
		}
	}
	return SP_RET_SUCCESS;
}
/*
 *
 *external function can call this function to send the event, the parameter is key composed flag, such as "key_left_short_press, both_key_long_press" and so on. 2th parameter key_action_type means KEY_PRESS or KEY_RELEASE or KEY_NOTHING. it designed for only send press event when the action is smaller than 5.
 *
 *
*/
int sp_key_event_send(SP_KEY_MODE flag, SP_KEY_ACTION_TYPE key_action_type)
{
	//Display* disp = XOpenDisplay( NULL );
	//if( disp == NULL )
		//return 1;
	int sp_event_flag = 0; /*default is 0. means system will send press and release event together*/
	if(flag < KEY_LEFT_SHORT_PRESS || flag >= KEY_NONE_PRESS)
	{	
		if(flag == KEY_NONE_PRESS)
			return SP_RET_SUCCESS;
		else
			return SP_RET_FAILED;
	}
	int action = sp_key_action[flag];
	//SP_TRACE("SP_TRACE_LEVEL_DEBUG", "flag = %d , action = %d ", flag , action); 	
	switch(flag)
	{
		case KEY_LEFT_SHORT_PRESS:
		case KEY_RIGHT_SHORT_PRESS:
		case KEY_BOTH_SHORT_PRESS:
			sp_event_flag = 0; /*if button is short press, it straitly means system will send press and release event*/
			break;
		default: /* when flag is LONG press */
			if(action > SP_KEY_CTRL_ACTION)
			{
				if(key_action_type == SP_KEY_PRESS)
					sp_event_flag = 0;	
				else 
					return SP_RET_SUCCESS; /* when action > 5, should not process the key long release event any more */
			}
			else
			{
				if(key_action_type == SP_KEY_PRESS)
					sp_event_flag = 1; /*result is 1, means system will only send press event*/	
				else if(key_action_type == SP_KEY_RELEASE)
					sp_event_flag = 2; /*result is 2, means system will only send release event*/
				else
					return SP_RET_SUCCESS; /* when action > 5, should not process the key long release event any more */
			}
			break;
	}
	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"sp_event_flag = %d, 0: send press/release event, 1: send press event, 2: send release event", sp_event_flag);	

	Display* disp = XOpenDisplay(":1.0");/*for ev_touch program*/
    if( disp != NULL )
	{
		SP_TRACE(SP_TRACE_LEVEL_DEBUG,"OPen Display1 OK...",NULL);
		sp_action_event_send(action, sp_event_flag, disp);
	}
	else
	{
		//disp = XOpenDisplay(":0.0");/*open current display*/	
		disp = XOpenDisplay(NULL);/*open current display for any user*/	
		if(disp == NULL)
		{
			SP_TRACE(SP_TRACE_LEVEL_ERROR,"Display1 not exist, meanwhile, OPen Display0 Error...",NULL);
    		return SP_RET_FAILED;
		}
		else
			sp_action_event_send(action, sp_event_flag, disp);
	}
#if 0
	switch(action)
	{
		case 0:
			g_print("%s:: send mouse left button event...\n",__func__);
			XTestFakeButtonEvent( disp, 1, True, CurrentTime );/*mouse left button press*/
			XTestFakeButtonEvent( disp, 1, False, CurrentTime );
			break;
		case 1:
			g_print("%s:: send mouse right button event...\n",__func__);
			XTestFakeButtonEvent( disp, 3, True, CurrentTime );/*mouse right button press*/
			XTestFakeButtonEvent( disp, 3, False, CurrentTime );
			break;
		case 2:
			g_print("%s:: send mouse middle button event...\n",__func__);
			XTestFakeButtonEvent( disp, 2, True, CurrentTime );/*mouse middle button press*/
			XTestFakeButtonEvent( disp, 2, False, CurrentTime );
			break;
		case 3:
			g_print("%s:: send KEY ALT_L event...\n",__func__);
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), True, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), False, CurrentTime );
			break;
		case 4:
			g_print("%s:: send KEY CTRL_L event...\n",__func__);
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_L), True, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_L), False, CurrentTime );
			break;
		case 5:
			g_print("%s:: send KEY F2 event...\n",__func__);
			//XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Scroll_Lock), True, CurrentTime );
			//XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Scroll_Lock), False, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F2), True, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F2), False, CurrentTime );
			break;
		case 6:
			g_print("%s:: send KEY ALT+F4 event...\n",__func__);
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), True, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F4), True, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F4), False, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), False, CurrentTime );
			break;
		case 7:
			g_print("%s:: send KEY F3 event...\n",__func__);
			//XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_R), True, CurrentTime );
			//XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_R), False, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F3), True, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F3), False, CurrentTime );
			break;
		case 8:
			g_print("%s:: send KEY F4 event...\n",__func__);
			//XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_R), True, CurrentTime );
			//XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_R), False, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F4), True, CurrentTime );
			XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_F4), False, CurrentTime );
			break;
		case 9:
			g_print("%s:: nothing to do...\n",__func__);
		default:
			break;
	}
#endif
	XCloseDisplay( disp );
	return SP_RET_SUCCESS;
}
