#include "sp_get_event.h"
#include "sp_key_action.h"
#include "sp_timer.h"
#include "sp_key_gconf.h"
#include "sp_error.h"

#include <linux/input.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>


/*
 *
 *
 the mutex is used to process the key composed event.detailed as follows:
if left/right key is pressed, then set left/right mutex flag is pressed. if another key pressed in 0.3s then set the both key flag is pressed. if a key released in 1s, then think both_key short released, but both_key flag will be set to release only when left and right key both released.any key press or release when both_key mutex pressed is invlid. if two key not be released in 1s, then it think as both_key long press. if not both_key pressed, and if this key is released in 1s, then think as this key short pressed. if not released in 1S,then think as long pressed. 
 *
 *
 * */
static int sp_key_mutex[3]={SP_KEY_RELEASE,SP_KEY_RELEASE,SP_KEY_RELEASE,};

/* only use in this file */
static int sp_key_flag = KEY_NONE_PRESS;

gboolean sp_key_type_judge_callback(gpointer gdata)
{
	sp_timer_status_set(SP_KEY_TYPE_JUDGE_TIMER,SP_TIMER_STATUS_OFF);
	return FALSE;
}
/*
 *
 *if the timer is timeout, then it means you press the key for a long time, it means long press.
 *
 *
*/
gboolean sp_key_press_type_judge_callback(gpointer gdata)
{
	switch(sp_key_flag)
	{
		case KEY_LEFT_SHORT_PRESS:
			sp_key_flag = KEY_LEFT_LONG_PRESS;
			break;
		case KEY_RIGHT_SHORT_PRESS:
			sp_key_flag = KEY_RIGHT_LONG_PRESS;
			break;
		case KEY_BOTH_SHORT_PRESS:
			sp_key_flag = KEY_BOTH_LONG_PRESS;
			break;
		default:
			break;
	}
	sp_timer_status_set(SP_KEY_PRESS_JUDGE_TIMER,SP_TIMER_STATUS_OFF);
	sp_key_event_send(sp_key_flag, SP_KEY_PRESS);
	//sp_key_flag = KEY_NONE_PRESS;
	return FALSE;
}
/*
 *
 *
 *after get event from /dev/input/event1, then process the key to get key composed type
 *
 *
 */
static void sp_key_detached(SP_KEY_TYPE sp_key_type, SP_KEY_ACTION_TYPE sp_key_action_type)
{
	SP_TIMER_STATUS sp_timer_status;
	int sp_key_type_wait_time;
	int sp_key_press_wait_time;
	/*only both_key flag is released, then key press is valid and can be processed*/
	if(sp_key_action_type == SP_KEY_PRESS && sp_key_mutex[SP_KEY_BOTH] == SP_KEY_RELEASE)
	{
		/*press one key , if you press another key in 0.3S, then can be think as both key simotanously pressed, i realise the procedure by check the 0.3s timer is on or off, if the 0.3s timer is on, then it means two keys simotanously pressed. if 0.3s timer is off, then it means only one key is pressed*/ 
		sp_timer_status = sp_timer_status_get(SP_KEY_TYPE_JUDGE_TIMER);
		if(sp_timer_status == SP_TIMER_STATUS_ON)
		{
			sp_key_press_wait_time = sp_gconf_value_get_int(SP_GCONF_KEY_PRESS_WAIT_TIME);
			if(sp_key_press_wait_time == 0)
				sp_key_press_wait_time = SP_KEY_PRESS_TIMER_INTERVAL;

			sp_remove_timer(SP_KEY_PRESS_JUDGE_TIMER);/**/
			sp_key_flag = KEY_BOTH_SHORT_PRESS;/*is 0.3s timer is on, it means both key is pressed simotanously*/
			sp_key_mutex[SP_KEY_BOTH] = SP_KEY_PRESS;/*set the mutex of both_key flag to press*/
			sp_add_timer(sp_key_press_wait_time,SP_KEY_PRESS_JUDGE_TIMER,sp_key_press_type_judge_callback,NULL);/*reset the 1s timer to restart key pressed type getting*/
		}	
		/*both mutex left key flag released and mutex right key flag released, then means one key pressed*/ 
		else if(SP_KEY_RELEASE == sp_key_mutex[SP_KEY_LEFT] && SP_KEY_RELEASE == sp_key_mutex[SP_KEY_RIGHT])
		{
			sp_key_press_wait_time = sp_gconf_value_get_int(SP_GCONF_KEY_PRESS_WAIT_TIME);
			if(sp_key_press_wait_time == 0)
				sp_key_press_wait_time = SP_KEY_PRESS_TIMER_INTERVAL;

			sp_key_type_wait_time = sp_gconf_value_get_int(SP_GCONF_KEY_TYPE_WAIT_TIME);
			if(sp_key_type_wait_time == 0)
				sp_key_type_wait_time = SP_KEY_TYPE_TIMER_INTERVAL;

			/*set key composed flag*/
			sp_key_flag = sp_key_type == SP_KEY_LEFT ? KEY_LEFT_SHORT_PRESS : KEY_RIGHT_SHORT_PRESS;

			if(sp_key_type == SP_KEY_LEFT)
				/*if left key pressed , then should be set the mutex key left flag to press, so only when this key is released, program can get another key, or else other key pressed is invlaid*/
				sp_key_mutex[SP_KEY_LEFT] = SP_KEY_PRESS;
			else if(sp_key_type == SP_KEY_RIGHT)
				/*if right key pressed , then should be set the mutex key right flag to press, so only when this key is released, program can get another key, or else other key pressed is invlaid*/
				sp_key_mutex[SP_KEY_RIGHT] = SP_KEY_PRESS;
			/*set timer 0.3S to get key composed type*/
			sp_add_timer(sp_key_type_wait_time,SP_KEY_TYPE_JUDGE_TIMER,sp_key_type_judge_callback, NULL);
			/*set timer 1S to get key long press or short press*/
			sp_add_timer(sp_key_press_wait_time,SP_KEY_PRESS_JUDGE_TIMER,sp_key_press_type_judge_callback,NULL);
		}
	}
	/*key release*/
	else if(sp_key_action_type == SP_KEY_RELEASE)
	{
		if(sp_key_type == SP_KEY_LEFT)
		{
			/*only mutex right key flag is equal with both key flag, that is mean if both mutex right key flag and both key flag is 0,or both mutex right key flag and both key flag is 1, this design goals is for the condition to send emulate key event based on a. only one key pressed , and then released, b. both key pressed, then one key released*/ 
			if(sp_key_mutex[SP_KEY_RIGHT] == sp_key_mutex[SP_KEY_BOTH])
			{
				sp_remove_timer(SP_KEY_PRESS_JUDGE_TIMER);
				sp_remove_timer(SP_KEY_TYPE_JUDGE_TIMER);
				sp_key_event_send(sp_key_flag, SP_KEY_RELEASE);/*this flag*/
				/*reset key flag*/
				sp_key_flag = KEY_NONE_PRESS;
			}
			sp_key_mutex[SP_KEY_LEFT] = SP_KEY_RELEASE;
		}
		else if(sp_key_type == SP_KEY_RIGHT)
		{
			/*only mutex left key flag is equal with both key flag, that is mean if both mutex left key flag and both key flag is 0,or both mutex left key flag and both key flag is 1, this design goals is for the condition to send emulate key event based on a. only one key pressed , and then released, b. both key pressed, then one key released*/ 
			if(sp_key_mutex[SP_KEY_LEFT] == sp_key_mutex[SP_KEY_BOTH])
			{
				sp_remove_timer(SP_KEY_PRESS_JUDGE_TIMER);
				sp_remove_timer(SP_KEY_TYPE_JUDGE_TIMER);
				sp_key_event_send(sp_key_flag, SP_KEY_RELEASE);
				sp_key_flag = KEY_NONE_PRESS;
			}
			sp_key_mutex[SP_KEY_RIGHT] = SP_KEY_RELEASE;
		}
		/*only left key and right key released , then both key flag can be set to release*/
		if(sp_key_mutex[SP_KEY_RIGHT] == SP_KEY_RELEASE && sp_key_mutex[SP_KEY_LEFT] == SP_KEY_RELEASE)
			sp_key_mutex[SP_KEY_BOTH] = SP_KEY_RELEASE;
	}
}

/*
 *
 * if there is key event can be read, then read the evdev standard key event from /dev/input/event1, and then get the event information based on the evdev parameters,there are 4 events "left key press, left key release, right key press, right key release", after that, call the key_detached function to process the event to know the key composed type, 6 types, "left short press, left long press, right key short press, right key long press, both key short key press, both key long press ". and then call function to send the event
 *
 *
*/
gboolean sp_read_event_key(GIOChannel *source, GIOCondition condition, gpointer data)
{
    //g_print("%s!\n",__func__);

    GIOError err;

    gsize count;

    //sp_key_app *app = (sp_key_app *)data;

    struct input_event buf;

    memset(&buf, 0x00, sizeof(buf));

    /*start to get event*/ 
    err = g_io_channel_read (source, (gchar *)&buf, sizeof(struct input_event), &count);
    if (err)
    {
        if (err != G_IO_ERROR_AGAIN)
            return FALSE;
    }
    else if (count == 0)
        return FALSE;

    //g_print("%s:: type = %x, code = %d, value = %d!\n",__func__, buf.type, buf.code, buf.value);

    if (buf.type == SP_EVDEV_KEY_TYPE && buf.code == SP_EVDEV_LEFT_KEY_CODE)
	{
		if(buf.value == SP_KEY_PRESS)
		{
			SP_TRACE(SP_TRACE_LEVEL_DEBUG,"left key pressed",NULL);
			sp_key_detached(SP_KEY_LEFT,SP_KEY_PRESS);
		}
		if(buf.value == SP_KEY_RELEASE)
		{
			SP_TRACE(SP_TRACE_LEVEL_DEBUG,"left key released",NULL);
			sp_key_detached(SP_KEY_LEFT,SP_KEY_RELEASE);
		}
	}
	else if(buf.type == SP_EVDEV_KEY_TYPE && buf.code == SP_EVDEV_RIGHT_KEY_CODE)
	{
		if(buf.value == SP_KEY_PRESS)
		{
			SP_TRACE(SP_TRACE_LEVEL_DEBUG,"right key pressed",NULL);
			sp_key_detached(SP_KEY_RIGHT,SP_KEY_PRESS);
		}
		if(buf.value == SP_KEY_RELEASE)
		{
			SP_TRACE(SP_TRACE_LEVEL_DEBUG,"right key released",NULL);
			sp_key_detached(SP_KEY_RIGHT,SP_KEY_RELEASE);
		}
	}
	return TRUE;
}
/*
 * 
 * monitor the key event from /dev/input/event1. use iochannel to loop monitor
 *
 *
*/
void sp_init_event_monitor(sp_iochannel *app)
{
    int fd = -1;
    fd = open(SP_KEY_INPUT_NODE, O_RDONLY|O_NONBLOCK, 0644);
    if ( fd < 0)
    {
		SP_TRACE(SP_TRACE_LEVEL_ERROR,"open file error!",NULL);
        exit(-1);
        //return SP_RET_FAILED;
    }
	
	SP_TRACE(SP_TRACE_LEVEL_DEBUG,"%s:: start to get event from /dev/input/event1...",__func__);

    app->io_channel = g_io_channel_unix_new (fd);
    g_io_channel_set_encoding (app->io_channel, NULL, NULL);

    app->source_id = g_io_add_watch (app->io_channel, G_IO_IN, sp_read_event_key, app);
}

