#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include "sp_error.h"
#ifndef SP_TEST
#include "sp_key_gconf.h"
#endif

#include <pwd.h>
#include <sys/types.h>

sp_trace_t g_sTrace = {NULL, SP_TRACE_LEVEL_DEBUG_LOW, SP_TRUE, SP_TRACE_FILENAME, 1000000};

void SP_PRINTF_FUNC( int level, const char *file,const int line,const char *func, char *format, ... )
{
	char MsgText[1024];
    va_list ap;

	memset(MsgText, 0x00, sizeof(MsgText));
    va_start(ap, format);
    vsnprintf(MsgText, sizeof(MsgText), format, ap);
    va_end(ap);

	{
		char	timetmp[128];
		char	cLevel;
		struct timeval sTime;
		int		iUTime;

		memset(timetmp, 0x00, sizeof(timetmp));
		gettimeofday(&sTime, NULL);
		iUTime = sTime.tv_usec;
		strftime(timetmp, sizeof(timetmp), "%Y/%m/%d %X", localtime(&sTime.tv_sec));
		switch(level){
			case SP_TRACE_LEVEL_CRITICAL:
				cLevel = 'C';
				break;
			case SP_TRACE_LEVEL_ERROR:
				cLevel = 'E';
				break;
			case SP_TRACE_LEVEL_WARNING:
				cLevel = 'W';
				break;
			case SP_TRACE_LEVEL_INFO:
				cLevel = 'I';
				break;
			case SP_TRACE_LEVEL_DEBUG:
				cLevel = 'D';
				break;
			case SP_TRACE_LEVEL_DEBUG_LOW:
				cLevel = '?';
				break;
			default:
				cLevel = 'U';
				break;
		}
		if(g_sTrace.iTrace2Console){
			fprintf(stderr, "(%c)[%s.%06d]	%s	<%s>{%s:%d}\n", 
					cLevel, timetmp, iUTime, MsgText, func, file, line);
		}
		if(g_sTrace.pFPTrace  != NULL)	{
			fprintf(g_sTrace.pFPTrace, "(%c)[%s.%06d]	%s	<%s>{%s:%d}\n", 
					cLevel, timetmp, iUTime, MsgText, func, file, line);
			fflush(g_sTrace.pFPTrace);
			fseek(g_sTrace.pFPTrace,0,SEEK_END);
			if(ftell(g_sTrace.pFPTrace) > g_sTrace.iTraceSize*1000){
				char cOldFileName[_MAX_PATH];
				memset(cOldFileName, 0x00, _MAX_PATH);
				SP_TRACE_FILE_CLOSE(g_sTrace.pFPTrace);
				strcpy(cOldFileName, g_sTrace.cTraceFileName);
				strcat(cOldFileName, ".OLD" );
				remove(cOldFileName);
				if ((rename(g_sTrace.cTraceFileName, cOldFileName)) < 0){
					fprintf(stderr, "SP_PRINTF_FUNC: Can't rename file(%s -> %s)\n",
							g_sTrace.cTraceFileName, cOldFileName);
				}
				SP_TRACE_FILE_OPEN(g_sTrace.cTraceFileName, g_sTrace.pFPTrace);
			}
		}else{
			if(strlen(g_sTrace.cTraceFileName) > 0){
				FILE *fp = NULL;
    			SP_TRACE_FILE_OPEN(g_sTrace.cTraceFileName, fp);
	    		if(fp != NULL){
					fflush(fp);
					fprintf(fp, " %c)[%s.%06d]	%s	<%s>{%s:%d}\n",
						cLevel, timetmp, iUTime, MsgText, func, file, line);

					if(ftell(fp) > g_sTrace.iTraceSize*1000){
						char cOldFileName[_MAX_PATH];
						memset(cOldFileName, 0x00, _MAX_PATH);
						SP_TRACE_FILE_CLOSE(fp);
						strcpy(cOldFileName, g_sTrace.cTraceFileName);
						strcat(cOldFileName, ".OLD" );
						remove(cOldFileName);
						if ((rename(g_sTrace.cTraceFileName, cOldFileName)) < 0){
							fprintf(stderr, "SP_PRINTF_FUNC: Can't rename file(%s -> %s)\n",
									g_sTrace.cTraceFileName, cOldFileName);
						}
					}else{
	    				SP_TRACE_FILE_CLOSE(fp);
					}
	    		}
            }
		}
	}
}


#ifndef SP_TEST

char *get_current_user_dir()
{
	uid_t my_uid;
    my_uid = getuid();
	struct passwd *my_info;
    printf("spider:: my uid = [%d]\n", my_uid);
	my_info = getpwuid( my_uid );
	printf( "spider:: my dir = [%s]\n", my_info->pw_dir);	
	return my_info->pw_dir;
}

void sp_trace_init(int openflag, char *plusname)
{
	char *env = NULL;
    memset(&g_sTrace, 0x00, sizeof(sp_trace_t));
	g_sTrace.pFPTrace = NULL;
	g_sTrace.iTraceLevel = SP_TRACE_LEVEL_DEBUG_LOW;
	g_sTrace.iTrace2Console = SP_TRUE;
	strcpy(g_sTrace.cTraceFileName, SP_TRACE_FILENAME);
	strcat(g_sTrace.cTraceFileName, ".");
	strcat(g_sTrace.cTraceFileName, plusname);
	g_sTrace.iTraceSize = SP_TRACE_SIZE;

	env = getenv(SP_ENV_TRACE_LEVEL);
	if(env){
		switch(*env){
			case '1':
				g_sTrace.iTraceLevel = SP_TRACE_LEVEL_ERROR;
				break;
			case '2':
				g_sTrace.iTraceLevel = SP_TRACE_LEVEL_WARNING;
				break;
			case '3':
				g_sTrace.iTraceLevel = SP_TRACE_LEVEL_INFO;
				break;
			case '4':
				g_sTrace.iTraceLevel = SP_TRACE_LEVEL_DEBUG;
				break;
			case '5':
				g_sTrace.iTraceLevel = SP_TRACE_LEVEL_DEBUG_LOW;
				break;
			case '0':
			default:
				g_sTrace.iTraceLevel = SP_TRACE_LEVEL_CRITICAL;
				break;
		}
	}else{
		g_sTrace.iTraceLevel = sp_gconf_value_get_int(SP_GCONF_TRACE_LEVEL);
		if(g_sTrace.iTraceLevel < 0){
			g_sTrace.iTraceLevel = SP_TRACE_LEVEL_ERROR;
		}
	}
	
	env = NULL;
	env = getenv(SP_ENV_TRACE2CONSOLE);
	if(env){
		if(!strcmp(env, SP_ENV_TRACE_YES)){
			g_sTrace.iTrace2Console = SP_TRUE;
		}else{
			g_sTrace.iTrace2Console = SP_FALSE;
		}
	}else{
		g_sTrace.iTrace2Console = SP_FALSE;
	}

	env = NULL;
	env = getenv(SP_ENV_TRACE_FILENAME);
	if(env){
		if(strlen(env)){
			strcpy(g_sTrace.cTraceFileName, env);
		}else{
			strcpy(g_sTrace.cTraceFileName, SP_TRACE_FILENAME);
		}
	}else{
		//char *p = get_current_user_dir();
		char *p;
		//char *p = sp_gconf_value_get_string(SP_GCONF_TRACE_PATH);/*not from gconf*/
		
		if(p){
			strcat(p,"/_SP_TRACE");
			printf("spider:: trace file = [%s]\n", p);
			strcpy(g_sTrace.cTraceFileName, p);
			//SP_FREE(p);/*not need free space,or encounter segment fault*/
		}else{
			strcpy(g_sTrace.cTraceFileName, SP_TRACE_FILENAME);
		}
	}
	if(plusname != NULL){
		strcat(g_sTrace.cTraceFileName, ".");
		strcat(g_sTrace.cTraceFileName, plusname);
	}
	
	env = NULL;
	env = getenv(SP_ENV_TRACE_SIZE);
	if(env){
		g_sTrace.iTraceSize = atoi(env);
		if(g_sTrace.iTraceSize < 1)/* trace size < 1KB to default */
			g_sTrace.iTraceSize = SP_TRACE_SIZE;
	}else{
		g_sTrace.iTraceSize = sp_gconf_value_get_int(SP_GCONF_TRACE_SIZE);
		if(g_sTrace.iTraceSize < 1){
			g_sTrace.iTraceSize = SP_TRACE_SIZE;
		}
	}

	if(openflag == 1){
		SP_TRACE_FILE_OPEN(g_sTrace.cTraceFileName, g_sTrace.pFPTrace);
	}

	SP_TRACE(SP_TRACE_LEVEL_INFO, 
			"SP_TRACE_LEVEL = %d SP_TRACE2CONSOLE = %s SP_TRACE_FILENAME = %s SP_TRACE_SIZE = %d kb",
			g_sTrace.iTraceLevel,
			g_sTrace.iTrace2Console == SP_TRUE?"yes":"no",
			g_sTrace.cTraceFileName,
			g_sTrace.iTraceSize);

	return;
}

#else

void sp_trace_init_test(int trace_level, char *trace_file_name)
{
	if((trace_level >= SP_TRACE_LEVEL_CRITICAL) && (trace_level <= SP_TRACE_LEVEL_DEBUG)){
		g_sTrace.iTraceLevel = trace_level;
	}else{
		g_sTrace.iTraceLevel = SP_TRACE_LEVEL_ERROR;
	}

	g_sTrace.iTrace2Console = SP_TRUE;

	if(NULL != trace_file_name){
		strcpy(g_sTrace.cTraceFileName, trace_file_name);
	}

	SP_TRACE(SP_TRACE_LEVEL_CRITICAL,
			"SP_TRACE_LEVEL = %d SP_TRACE2CONSOLE = %s SP_TRACE_FILENAME = %s",
			g_sTrace.iTraceLevel, g_sTrace.iTrace2Console == SP_TRUE?"yes":"no", g_sTrace.cTraceFileName);
	return;
}

#endif

void sp_trace_destroy()
{
	SP_TRACE_FILE_CLOSE( g_sTrace.pFPTrace);
}



void SP_FILEOUT_BINARY(char *pData,
								int iSize,
								char *pPathName,
								char *pPlusName)
{
	FILE *fdput = NULL;
	char filename[256],buff[17];
	size_t rtn;
	
	if(iSize == 0 || pPathName == NULL){
		fprintf(stderr, "%s parameter error.\n", __FUNCTION__);
		return;
	}
	if(pData == NULL){
		iSize = 0;
	}

	memset(filename, 0x00, sizeof(filename));
	strcat(filename, pPathName);
	if(pPlusName != NULL){
		strcat(filename, pPlusName);
	}
	if((fdput = fopen(filename, "ab+")) == NULL){
		return;
	}
	rtn = fwrite("<-POWERMANAGER->", sizeof(char), 16, fdput);
	memset(buff, 0x00, sizeof(buff));
	sprintf(buff, "%15dB", iSize);
	rtn = fwrite(buff, sizeof(char), 16, fdput);
	
	{/* time out */
		char	timetmp[33];
		struct timeval sTime;
		int		iUTime;

		gettimeofday(&sTime, NULL);
		iUTime = sTime.tv_usec;

		memset(timetmp, 0x00, sizeof(timetmp));
		strftime(timetmp, sizeof(timetmp), "      %Y/%m/%d %X", localtime(&sTime.tv_sec));
		rtn = fwrite(timetmp, sizeof(char), 25, fdput);

		memset(timetmp, 0x00, sizeof(timetmp));
		sprintf(timetmp, ".%06d", iUTime);
		rtn = fwrite(timetmp, sizeof(char), 7, fdput);
	}

	if(pData != NULL){
		rtn = fwrite(pData, sizeof(char), iSize, fdput);
	}else{
		rtn = fwrite("!!!   NULL   !!!", sizeof(char), 16, fdput);
	}
	
	if(iSize % 16 != 0){
		rtn = fwrite("****************", sizeof(char), 16 - iSize % 16, fdput);
	}
	
	fclose(fdput);
}


