# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import pkg_resources
import pgm
from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.label import Label

class WeatherWidget(Widget):
    def __init__(self):
        super(WeatherWidget, self).__init__()

        y_offset = 0.3
        x_margin = 0.05
        y_margin = 0.01

        self._city = Label()
        self.add(self._city)
        self._city.style.background_color = (0, 0, 0, 0)
        self._city._text.weight = pgm.TEXT_WEIGHT_BOLD
        self._city.width = 0.5
        self._city.height = 0.04
        self._city.x = x_margin
        self._city.y = y_offset
        y_offset += self._city.height + y_margin + 0.05
        self._city.visible = True
        
        self._sky = Label()
        self.add(self._sky)
        self._sky.style.background_color = (0, 0, 0, 0)
        self._sky.width = 0.5
        self._sky.height = 0.04
        self._sky.x = x_margin
        self._sky.y = y_offset
        y_offset += self._sky.height + y_margin
        self._sky.visible = True
        
        self._temperature = Label()
        self.add(self._temperature)
        self._temperature.style.background_color = (0, 0, 0, 0)
        self._temperature.width = 0.5
        self._temperature.height = 0.04
        self._temperature.x = x_margin
        self._temperature.y = y_offset
        y_offset += self._temperature.height + y_margin
        self._temperature.visible = True

        self._image = Image()
        self.add(self._image)
        self._image.bg_a = 0
        self._image.height = 0.7
        self._image.width = 0.4
        self._image.x = 0.5
        self._image.y = (1.0-self._image.height)/2.0
        self._image.visible = True
        self._image_file = None

    def set_city(self, value):
        self._city.text = value
    def get_city(self):
        return self._city.text
    city = property(get_city, set_city)
    
    def set_sky(self, value):
        self._sky.text = value
    def get_sky(self):
        return self._sky.text
    sky = property(get_sky, set_sky)
    
    def set_temperature(self, value):
        self._temperature.text = str(value) + " °C"
    def get_temperature(self):
        return self._temperature.text
    temperature = property(get_temperature, set_temperature)
    
    def set_image(self, value):
        if value:
            filename = pkg_resources.resource_filename('elisa.plugins.weather',
                    'data/%s.png' % value)
            self._image.set_from_file(filename)
        self._image_file = value
    def get_image(self):
        return self._image_file
    image = property(get_image, set_image)

