/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _BLINDS_WINDOW_H_
#define _BLINDS_WINDOW_H_

#include <glib.h>
#include <gtk/gtk.h>

#define BLINDS_TYPE_WINDOW (blinds_window_get_type ())

#define BLINDS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	BLINDS_TYPE_WINDOW, BlindsWindow))

#define BLINDS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	BLINDS_TYPE_WINDOW, BlindsWindowClass))

#define BLINDS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	BLINDS_TYPE_WINDOW))

#define BLINDS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	BLINDS_TYPE_WINDOW))

#define BLINDS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	BLINDS_TYPE_WINDOW, BlindsWindowClass))

typedef struct _BlindsWindow        BlindsWindow;
typedef struct _BlindsWindowClass   BlindsWindowClass;
typedef struct _BlindsWindowPrivate BlindsWindowPrivate;
 
struct _BlindsWindow
{
  GtkWindow        parent;	

  BlindsWindowPrivate *priv;
};

struct _BlindsWindowClass
{
  GtkWindowClass   parent_class;
};

GType       blinds_window_get_type (void) G_GNUC_CONST;

GtkWidget * blinds_window_new      (void);


#endif /* _BLINDS_WINDOW_H_ */

