/* libdeja-dup.c generated by valac, the Vala compiler
 * generated from libdeja-dup.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup Library
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <gio/gio.h>
#include <hacks.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gconf/gconf.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _gconf_engine_unref0(var) ((var == NULL) ? NULL : (var = (gconf_engine_unref (var), NULL)))


extern GConfClient* deja_dup_client;
GConfClient* deja_dup_client = NULL;

#define DEJA_DUP_INCLUDE_LIST_KEY "/apps/deja-dup/include-list"
#define DEJA_DUP_EXCLUDE_LIST_KEY "/apps/deja-dup/exclude-list"
#define DEJA_DUP_BACKEND_KEY "/apps/deja-dup/backend"
#define DEJA_DUP_ENCRYPT_KEY "/apps/deja-dup/encrypt"
#define DEJA_DUP_LAST_RUN_KEY "/apps/deja-dup/last-run"
#define DEJA_DUP_PERIODIC_KEY "/apps/deja-dup/periodic"
#define DEJA_DUP_PERIODIC_PERIOD_KEY "/apps/deja-dup/periodic-period"
GConfClient* deja_dup_get_gconf_client (void);
void deja_dup_update_last_run_timestamp (GError** error);
char* deja_dup_get_trash_path (void);
GFile* deja_dup_parse_dir (const char* dir);
GFile** deja_dup_parse_dir_list (GSList* dirs, int* result_length1);
void deja_dup_show_uri (GtkWindow* parent, const char* link);
void deja_dup_handle_about_uri (GtkAboutDialog* about, const char* link);
void deja_dup_handle_about_mail (GtkAboutDialog* about, const char* link);
static void _deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void _deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void _lambda19_ (GtkDialog* dlg, gint resp);
static void __lambda19__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void deja_dup_show_about (GObject* owner, GtkWindow* parent);
GtkWindow* deja_dup_get_topwindow (GtkWidget* w);
guint32 _dynamic_request_name2 (DBusGProxy* self, char* param1, guint32 param2, GError** error);
guint32 _dynamic_release_name3 (DBusGProxy* self, char* param1, GError** error);
gboolean deja_dup_set_bus_claimed (const char* busname, gboolean claim);
void deja_dup_set_gconf_client (void);
#define DEJA_DUP_SSH_USERNAME_KEY "/apps/deja-dup/ssh/username"
#define DEJA_DUP_SSH_SERVER_KEY "/apps/deja-dup/ssh/server"
#define DEJA_DUP_SSH_PORT_KEY "/apps/deja-dup/ssh/port"
#define DEJA_DUP_SSH_DIRECTORY_KEY "/apps/deja-dup/ssh/directory"
#define DEJA_DUP_FILE_PATH_KEY "/apps/deja-dup/file/path"
void deja_dup_convert_ssh_to_file (void);
void deja_dup_initialize (void);
char* deja_dup_get_file_desc (GFile* file);
char* deja_dup_get_location_desc (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const char* DEJA_DUP_authors[] = {"Michael Terry <mike@mterry.name>", NULL};
static const char* DEJA_DUP_artists[] = {"Andreas Nilsson <nisses.mail@home.se>", "Jakub Steiner <jimmac@novell.com>", "Michael Terry <mike@mterry.name>", NULL};
static const char* DEJA_DUP_documenters[] = {"Michael Terry <mike@mterry.name>", NULL};


void deja_dup_update_last_run_timestamp (GError** error) {
	GError * _inner_error_;
	GTimeVal _tmp0_ = {0};
	GTimeVal cur_time;
	char* cur_time_str;
	GConfClient* client;
	_inner_error_ = NULL;
	cur_time = (g_get_current_time (&_tmp0_), _tmp0_);
	g_get_current_time (&cur_time);
	cur_time_str = g_time_val_to_iso8601 (&cur_time);
	client = deja_dup_get_gconf_client ();
	gconf_client_set_string (client, DEJA_DUP_LAST_RUN_KEY, cur_time_str, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (cur_time_str);
		_g_object_unref0 (client);
		return;
	}
	_g_free0 (cur_time_str);
	_g_object_unref0 (client);
}


char* deja_dup_get_trash_path (void) {
	char* result;
	result = g_build_filename (g_get_user_data_dir (), "Trash", NULL);
	return result;
}


GFile* deja_dup_parse_dir (const char* dir) {
	GFile* result;
	char* s;
	g_return_val_if_fail (dir != NULL, NULL);
	s = g_strdup (dir);
	if (_vala_strcmp0 (s, "$HOME") == 0) {
		char* _tmp0_;
		s = (_tmp0_ = g_strdup (g_get_home_dir ()), _g_free0 (s), _tmp0_);
	} else {
		if (_vala_strcmp0 (s, "$DESKTOP") == 0) {
			char* _tmp1_;
			s = (_tmp1_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP)), _g_free0 (s), _tmp1_);
		} else {
			if (_vala_strcmp0 (s, "$DOCUMENTS") == 0) {
				char* _tmp2_;
				s = (_tmp2_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS)), _g_free0 (s), _tmp2_);
			} else {
				if (_vala_strcmp0 (s, "$DOWNLOAD") == 0) {
					char* _tmp3_;
					s = (_tmp3_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD)), _g_free0 (s), _tmp3_);
				} else {
					if (_vala_strcmp0 (s, "$MUSIC") == 0) {
						char* _tmp4_;
						s = (_tmp4_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_MUSIC)), _g_free0 (s), _tmp4_);
					} else {
						if (_vala_strcmp0 (s, "$PICTURES") == 0) {
							char* _tmp5_;
							s = (_tmp5_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_PICTURES)), _g_free0 (s), _tmp5_);
						} else {
							if (_vala_strcmp0 (s, "$PUBLIC_SHARE") == 0) {
								char* _tmp6_;
								s = (_tmp6_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE)), _g_free0 (s), _tmp6_);
							} else {
								if (_vala_strcmp0 (s, "$TEMPLATES") == 0) {
									char* _tmp7_;
									s = (_tmp7_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES)), _g_free0 (s), _tmp7_);
								} else {
									if (_vala_strcmp0 (s, "$TRASH") == 0) {
										char* _tmp8_;
										s = (_tmp8_ = deja_dup_get_trash_path (), _g_free0 (s), _tmp8_);
									} else {
										if (_vala_strcmp0 (s, "$VIDEOS") == 0) {
											char* _tmp9_;
											s = (_tmp9_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS)), _g_free0 (s), _tmp9_);
										} else {
											if (!g_path_is_absolute (s)) {
												char* _tmp10_;
												s = (_tmp10_ = g_build_filename (g_get_home_dir (), s, NULL), _g_free0 (s), _tmp10_);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = g_file_new_for_path (s);
	_g_free0 (s);
	return result;
}


GFile** deja_dup_parse_dir_list (GSList* dirs, int* result_length1) {
	GFile** result;
	GFile** _tmp2_;
	gint rv_size;
	gint rv_length1;
	gint _tmp1_;
	GFile** rv;
	gint i;
	GFile** _tmp5_;
	if (dirs == NULL) {
		GFile** _tmp0_;
		result = (_tmp0_ = g_new0 (GFile*, 0 + 1), *result_length1 = 0, _tmp0_);
		return result;
	}
	rv = (_tmp2_ = g_new0 (GFile*, (_tmp1_ = g_slist_length (dirs)) + 1), rv_length1 = _tmp1_, rv_size = rv_length1, _tmp2_);
	i = 0;
	{
		GSList* s_collection;
		GSList* s_it;
		s_collection = dirs;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			char* s;
			s = g_strdup ((const char*) s_it->data);
			{
				GFile* _tmp4_;
				GFile* *_tmp3_;
				_tmp3_ = &rv[i++];
				(*_tmp3_) = (_tmp4_ = deja_dup_parse_dir (s), _g_object_unref0 ((*_tmp3_)), _tmp4_);
				_g_free0 (s);
			}
		}
	}
	result = (_tmp5_ = rv, *result_length1 = rv_length1, _tmp5_);
	return result;
	rv = (_vala_array_free (rv, rv_length1, (GDestroyNotify) g_object_unref), NULL);
}


void deja_dup_show_uri (GtkWindow* parent, const char* link) {
	GError * _inner_error_;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (link != NULL);
	_inner_error_ = NULL;
	{
		hacks_show_uri (link, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch60_g_error;
			goto __finally60;
		}
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* dlg;
			dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not display %s"), link));
			gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) dlg);
			gtk_object_destroy ((GtkObject*) dlg);
			_g_error_free0 (e);
			_g_object_unref0 (dlg);
		}
	}
	__finally60:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


void deja_dup_handle_about_uri (GtkAboutDialog* about, const char* link) {
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	deja_dup_show_uri ((GtkWindow*) about, link);
}


void deja_dup_handle_about_mail (GtkAboutDialog* about, const char* link) {
	char* _tmp0_;
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	deja_dup_show_uri ((GtkWindow*) about, _tmp0_ = g_strdup_printf ("mailto:%s", link));
	_g_free0 (_tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	deja_dup_handle_about_mail (about, link_);
}


static void _deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	deja_dup_handle_about_uri (about, link_);
}


static void _lambda19_ (GtkDialog* dlg, gint resp) {
	GObject* about_owner;
	g_return_if_fail (dlg != NULL);
	about_owner = _g_object_ref0 (G_OBJECT (g_object_get_data ((GObject*) dlg, "owner")));
	g_object_set_data (about_owner, "about-dlg", NULL);
	gtk_object_destroy ((GtkObject*) dlg);
	_g_object_unref0 (about_owner);
}


static void __lambda19__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda19_ (_sender, response_id);
}


void deja_dup_show_about (GObject* owner, GtkWindow* parent) {
	GtkAboutDialog* about;
	GtkAboutDialog* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (owner != NULL);
	about = _g_object_ref0 (GTK_ABOUT_DIALOG (g_object_get_data (owner, "about-dlg")));
	if (about != NULL) {
		gtk_window_present ((GtkWindow*) about);
		_g_object_unref0 (about);
		return;
	}
	about = (_tmp0_ = g_object_ref_sink ((GtkAboutDialog*) gtk_about_dialog_new ()), _g_object_unref0 (about), _tmp0_);
	gtk_about_dialog_set_email_hook (_deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func, NULL, NULL);
	gtk_about_dialog_set_url_hook (_deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func, NULL, NULL);
	gtk_window_set_title ((GtkWindow*) about, _ ("About Déjà Dup"));
	gtk_about_dialog_set_authors (about, DEJA_DUP_authors);
	gtk_about_dialog_set_artists (about, DEJA_DUP_artists);
	gtk_about_dialog_set_documenters (about, DEJA_DUP_documenters);
	gtk_about_dialog_set_translator_credits (about, _ ("translator-credits"));
	gtk_about_dialog_set_logo_icon_name (about, PACKAGE);
	gtk_about_dialog_set_version (about, VERSION);
	gtk_about_dialog_set_website (about, "https://launchpad.net/deja-dup");
	gtk_about_dialog_set_license (about, _tmp1_ = g_strdup_printf ("%s\n\n%s\n\n%s", _ ("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version."), _ ("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details."), _ ("You should have received a copy of the GNU General Public License along with this program.  If not, see http://www.gnu.org/licenses/.")));
	_g_free0 (_tmp1_);
	gtk_about_dialog_set_wrap_license (about, TRUE);
	g_object_set_data (owner, "about-dlg", about);
	g_object_set_data ((GObject*) about, "owner", owner);
	gtk_window_set_transient_for ((GtkWindow*) about, parent);
	g_signal_connect ((GtkDialog*) about, "response", (GCallback) __lambda19__gtk_dialog_response, NULL);
	gtk_widget_show ((GtkWidget*) about);
	_g_object_unref0 (about);
}


GtkWindow* deja_dup_get_topwindow (GtkWidget* w) {
	GtkWindow* result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (w != NULL, NULL);
	w = gtk_widget_get_toplevel (w);
	if (w != NULL) {
		_tmp0_ = GTK_WIDGET_TOPLEVEL (w);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = _g_object_ref0 (GTK_WINDOW (w));
		return result;
	} else {
		result = NULL;
		return result;
	}
}


guint32 _dynamic_request_name2 (DBusGProxy* self, char* param1, guint32 param2, GError** error) {
	guint32 result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


guint32 _dynamic_release_name3 (DBusGProxy* self, char* param1, GError** error) {
	guint32 result;
	dbus_g_proxy_call (self, "ReleaseName", error, G_TYPE_STRING, param1, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


gboolean deja_dup_set_bus_claimed (const char* busname, gboolean claim) {
	gboolean result;
	GError * _inner_error_;
	g_return_val_if_fail (busname != NULL, FALSE);
	_inner_error_ = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch61_g_error;
			goto __finally61;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		if (claim) {
			char* _tmp0_;
			guint32 _tmp1_;
			guint32 _result_;
			_result_ = (_tmp1_ = _dynamic_request_name2 (bus, _tmp0_ = g_strconcat ("net.launchpad.deja-dup.", busname, NULL), (guint32) 4, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
			if (_inner_error_ != NULL) {
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (bus);
				goto __catch61_g_error;
				goto __finally61;
			}
			if (_result_ == DBUS_REQUEST_NAME_REPLY_EXISTS) {
				result = FALSE;
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (bus);
				return result;
			}
		} else {
			char* _tmp2_;
			guint32 _tmp3_;
			guint32 _result_;
			_result_ = (_tmp3_ = _dynamic_release_name3 (bus, _tmp2_ = g_strconcat ("net.launchpad.deja-dup.", busname, NULL), &_inner_error_), _g_free0 (_tmp2_), _tmp3_);
			if (_inner_error_ != NULL) {
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (bus);
				goto __catch61_g_error;
				goto __finally61;
			}
			_result_ = _result_;
		}
		_dbus_g_connection_unref0 (conn);
		_g_object_unref0 (bus);
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("libdeja-dup.vala:201: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally61:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


void deja_dup_set_gconf_client (void) {
	GError * _inner_error_;
	char* source_str;
	_inner_error_ = NULL;
	source_str = g_strdup (g_getenv ("GCONF_CONFIG_SOURCE"));
	if (source_str != NULL) {
		{
			GConfEngine* _tmp0_;
			GConfEngine* engine;
			GConfClient* _tmp1_;
			engine = (_tmp0_ = gconf_engine_get_for_address (source_str, &_inner_error_), (_tmp0_ == NULL) ? NULL : gconf_engine_ref (_tmp0_), _tmp0_);
			if (_inner_error_ != NULL) {
				goto __catch62_g_error;
				goto __finally62;
			}
			deja_dup_client = (_tmp1_ = _g_object_ref0 (gconf_client_get_for_engine (engine)), _g_object_unref0 (deja_dup_client), _tmp1_);
			_gconf_engine_unref0 (engine);
		}
		goto __finally62;
		__catch62_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_printerr ("%s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally62:
		if (_inner_error_ != NULL) {
			_g_free0 (source_str);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (source_str);
}


GConfClient* deja_dup_get_gconf_client (void) {
	GConfClient* result;
	if (deja_dup_client == NULL) {
		GConfClient* _tmp0_;
		deja_dup_client = (_tmp0_ = _g_object_ref0 (gconf_client_get_default ()), _g_object_unref0 (deja_dup_client), _tmp0_);
	}
	result = _g_object_ref0 (deja_dup_client);
	return result;
}


void deja_dup_convert_ssh_to_file (void) {
	GError * _inner_error_;
	GConfClient* client;
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	{
		char* backend;
		backend = g_strdup (gconf_client_get_string (client, DEJA_DUP_BACKEND_KEY, &_inner_error_));
		if (_inner_error_ != NULL) {
			goto __catch63_g_error;
			goto __finally63;
		}
		if (_vala_strcmp0 (backend, "ssh") == 0) {
			char* server;
			gboolean _tmp0_ = FALSE;
			gconf_client_set_string (client, DEJA_DUP_BACKEND_KEY, "file", &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (backend);
				goto __catch63_g_error;
				goto __finally63;
			}
			server = g_strdup (gconf_client_get_string (client, DEJA_DUP_SSH_SERVER_KEY, &_inner_error_));
			if (_inner_error_ != NULL) {
				_g_free0 (backend);
				goto __catch63_g_error;
				goto __finally63;
			}
			if (server != NULL) {
				_tmp0_ = _vala_strcmp0 (server, "") != 0;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				char* username;
				gint port;
				char* directory;
				char* gio_uri;
				gboolean _tmp1_ = FALSE;
				char* _tmp4_;
				gboolean _tmp8_ = FALSE;
				username = g_strdup (gconf_client_get_string (client, DEJA_DUP_SSH_USERNAME_KEY, &_inner_error_));
				if (_inner_error_ != NULL) {
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch63_g_error;
					goto __finally63;
				}
				port = gconf_client_get_int (client, DEJA_DUP_SSH_PORT_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (username);
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch63_g_error;
					goto __finally63;
				}
				directory = g_strdup (gconf_client_get_string (client, DEJA_DUP_SSH_DIRECTORY_KEY, &_inner_error_));
				if (_inner_error_ != NULL) {
					_g_free0 (username);
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch63_g_error;
					goto __finally63;
				}
				gio_uri = g_strdup ("ssh://");
				if (username != NULL) {
					_tmp1_ = _vala_strcmp0 (username, "") != 0;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					char* _tmp3_;
					char* _tmp2_;
					gio_uri = (_tmp3_ = g_strconcat (gio_uri, _tmp2_ = g_strconcat (username, "@", NULL), NULL), _g_free0 (gio_uri), _tmp3_);
					_g_free0 (_tmp2_);
				}
				gio_uri = (_tmp4_ = g_strconcat (gio_uri, server, NULL), _g_free0 (gio_uri), _tmp4_);
				if (port > 0) {
					char* _tmp7_;
					char* _tmp6_;
					char* _tmp5_;
					gio_uri = (_tmp7_ = g_strconcat (gio_uri, _tmp6_ = g_strconcat (":", _tmp5_ = g_strdup_printf ("%i", port), NULL), NULL), _g_free0 (gio_uri), _tmp7_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp5_);
				}
				if (directory == NULL) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = _vala_strcmp0 (directory, "") == 0;
				}
				if (_tmp8_) {
					char* _tmp9_;
					gio_uri = (_tmp9_ = g_strconcat (gio_uri, "/", NULL), _g_free0 (gio_uri), _tmp9_);
				} else {
					if (g_utf8_get_char (g_utf8_offset_to_pointer (directory, 0)) != '/') {
						char* _tmp11_;
						char* _tmp10_;
						gio_uri = (_tmp11_ = g_strconcat (gio_uri, _tmp10_ = g_strconcat ("/", directory, NULL), NULL), _g_free0 (gio_uri), _tmp11_);
						_g_free0 (_tmp10_);
					} else {
						char* _tmp12_;
						gio_uri = (_tmp12_ = g_strconcat (gio_uri, directory, NULL), _g_free0 (gio_uri), _tmp12_);
					}
				}
				gconf_client_set_string (client, DEJA_DUP_FILE_PATH_KEY, gio_uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (username);
					_g_free0 (directory);
					_g_free0 (gio_uri);
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch63_g_error;
					goto __finally63;
				}
				_g_free0 (username);
				_g_free0 (directory);
				_g_free0 (gio_uri);
			}
			_g_free0 (server);
		}
		_g_free0 (backend);
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("libdeja-dup.vala:268: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally63:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (client);
}


void deja_dup_initialize (void) {
	deja_dup_set_gconf_client ();
	deja_dup_convert_ssh_to_file ();
}


char* deja_dup_get_file_desc (GFile* file) {
	char* result;
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_inner_error_ = NULL;
	{
		GFileInfo* info;
		info = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch64_g_error;
			goto __finally64;
		}
		if (g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION)) {
			result = g_strdup (g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION));
			_g_object_unref0 (info);
			return result;
		} else {
			if (g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME)) {
				result = g_strdup (g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME));
				_g_object_unref0 (info);
				return result;
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("libdeja-dup.vala:290: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally64:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (_tmp1_ = g_path_get_basename (_tmp0_ = g_file_get_parse_name (file)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


char* deja_dup_get_location_desc (void) {
	char* result;
	GError * _inner_error_;
	GFile* file;
	_inner_error_ = NULL;
	file = NULL;
	{
		char* val;
		val = g_strdup (gconf_client_get_string (deja_dup_client, DEJA_DUP_BACKEND_KEY, &_inner_error_));
		if (_inner_error_ != NULL) {
			goto __catch65_g_error;
			goto __finally65;
		}
		if (_vala_strcmp0 (val, "s3") == 0) {
			result = g_strdup (_ ("Amazon S3"));
			_g_free0 (val);
			_g_object_unref0 (file);
			return result;
		} else {
			const char* _tmp0_;
			char* _tmp1_;
			GFile* _tmp3_;
			_tmp0_ = gconf_client_get_string (deja_dup_client, DEJA_DUP_FILE_PATH_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (val);
				goto __catch65_g_error;
				goto __finally65;
			}
			val = (_tmp1_ = g_strdup (_tmp0_), _g_free0 (val), _tmp1_);
			if (val == NULL) {
				char* _tmp2_;
				val = (_tmp2_ = g_strdup (""), _g_free0 (val), _tmp2_);
			}
			file = (_tmp3_ = _g_object_ref0 (g_file_parse_name (val)), _g_object_unref0 (file), _tmp3_);
		}
		result = deja_dup_get_file_desc (file);
		_g_free0 (val);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("libdeja-dup.vala:312: %s\n", e->message);
			result = g_strdup (_ ("Unknown"));
			_g_error_free0 (e);
			_g_object_unref0 (file);
			return result;
		}
	}
	__finally65:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (file);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




