/* BackendFile.c generated by valac, the Vala compiler
 * generated from BackendFile.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <hacks.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_FILE (deja_dup_backend_file_get_type ())
#define DEJA_DUP_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile))
#define DEJA_DUP_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))
#define DEJA_DUP_IS_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_IS_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_BACKEND_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))

typedef struct _DejaDupBackendFile DejaDupBackendFile;
typedef struct _DejaDupBackendFileClass DejaDupBackendFileClass;
typedef struct _DejaDupBackendFilePrivate DejaDupBackendFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	char* (*get_location) (DejaDupBackend* self, GError** error);
	char* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	void (*get_envp) (DejaDupBackend* self, GError** error);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	void (*ask_password) (DejaDupBackend* self);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendFile {
	DejaDupBackend parent_instance;
	DejaDupBackendFilePrivate * priv;
};

struct _DejaDupBackendFileClass {
	DejaDupBackendClass parent_class;
};

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()

static gpointer deja_dup_backend_file_parent_class = NULL;

#define DEJA_DUP_FILE_PATH_KEY "/apps/deja-dup/file/path"
GType deja_dup_backend_get_type (void);
GType deja_dup_operation_mode_get_type (void);
GType deja_dup_backend_file_get_type (void);
enum  {
	DEJA_DUP_BACKEND_FILE_DUMMY_PROPERTY
};
static void deja_dup_backend_set_toplevel (DejaDupBackend* self, GtkWindow* value);
DejaDupBackendFile* deja_dup_backend_file_new (GtkWindow* win);
DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type, GtkWindow* win);
GtkWindow* deja_dup_backend_get_toplevel (DejaDupBackend* self);
static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base);
GConfClient* deja_dup_get_gconf_client (void);
static char* deja_dup_backend_file_get_location_from_gconf (DejaDupBackendFile* self, GError** error);
GQuark deja_dup_backup_error_quark (void);
static char* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error);
static char* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv);
static void deja_dup_backend_file_check_if_password_needed (DejaDupBackendFile* self, GFile* file);
static void _g_list_free_g_free (GList* self);
static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GError** error);
static void _lambda7_ (GObject* o, GAsyncResult* r, DejaDupBackendFile* self);
static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _lambda8_ (GObject* o, GAsyncResult* r, DejaDupBackendFile* self);
static void __lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void deja_dup_backend_file_real_ask_password (DejaDupBackend* base);



DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type, GtkWindow* win) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupBackendFile * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "toplevel";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, win);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupBackendFile* deja_dup_backend_file_new (GtkWindow* win) {
	return deja_dup_backend_file_construct (DEJA_DUP_TYPE_BACKEND_FILE, win);
}


static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	DejaDupBackend* result;
	self = (DejaDupBackendFile*) base;
	result = (DejaDupBackend*) deja_dup_backend_file_new (deja_dup_backend_get_toplevel ((DejaDupBackend*) self));
	return result;
}


static char* deja_dup_backend_file_get_location_from_gconf (DejaDupBackendFile* self, GError** error) {
	char* result;
	GError * _inner_error_;
	GConfClient* client;
	char* path;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	path = g_strdup (gconf_client_get_string (client, DEJA_DUP_FILE_PATH_KEY, &_inner_error_));
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	result = path;
	_g_object_unref0 (client);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static char* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	char* result;
	GError * _inner_error_;
	char* path;
	GFile* file;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	self = (DejaDupBackendFile*) base;
	_inner_error_ = NULL;
	path = deja_dup_backend_file_get_location_from_gconf (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	file = _g_object_ref0 (g_file_parse_name (path));
	if ((_tmp1_ = (_tmp0_ = g_file_get_path (file)) == NULL, _g_free0 (_tmp0_), _tmp1_)) {
		_inner_error_ = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_BAD_CONFIG, _ ("GVFS FUSE is not installed"));
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			_g_object_unref0 (file);
			return NULL;
		}
	}
	result = (_tmp3_ = g_strconcat ("file://", _tmp2_ = g_file_get_path (file), NULL), _g_free0 (_tmp2_), _tmp3_);
	_g_free0 (path);
	_g_object_unref0 (file);
	return result;
	_g_free0 (path);
	_g_object_unref0 (file);
}


static char* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	char* result;
	GError * _inner_error_;
	char* _tmp0_;
	self = (DejaDupBackendFile*) base;
	_inner_error_ = NULL;
	_tmp0_ = deja_dup_backend_file_get_location_from_gconf (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp0_;
	return result;
}


static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv) {
	DejaDupBackendFile * self;
	GError * _inner_error_;
	self = (DejaDupBackendFile*) base;
	_inner_error_ = NULL;
	if (mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
		{
			char* path;
			path = deja_dup_backend_file_get_location_from_gconf (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
				goto __finally0;
			}
			if (path != NULL) {
				GFile* file;
				file = _g_object_ref0 (g_file_parse_name (path));
				if (g_file_is_native (file)) {
					char* _tmp0_;
					*argv = g_list_prepend (*argv, g_strdup_printf ("--exclude=%s", _tmp0_ = g_file_get_path (file)));
					_g_free0 (_tmp0_);
				}
				_g_object_unref0 (file);
			}
			_g_free0 (path);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("BackendFile.vala:69: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	GError * _inner_error_;
	char* path;
	GFile* file;
	GMount* mount;
	GList* _tmp2_;
	self = (DejaDupBackendFile*) base;
	_inner_error_ = NULL;
	path = deja_dup_backend_file_get_location_from_gconf (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	file = _g_object_ref0 (g_file_parse_name (path));
	mount = NULL;
	if (!g_file_is_native (file)) {
		{
			GMount* _tmp0_;
			GMount* _tmp1_;
			_tmp0_ = g_file_find_enclosing_mount (file, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
				goto __finally1;
			}
			mount = (_tmp1_ = _tmp0_, _g_object_unref0 (mount), _tmp1_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			_g_object_unref0 (file);
			_g_object_unref0 (mount);
			return;
		}
		if (mount == NULL) {
			deja_dup_backend_file_check_if_password_needed (self, file);
			_g_free0 (path);
			_g_object_unref0 (file);
			_g_object_unref0 (mount);
			return;
		}
	}
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, _tmp2_ = NULL, NULL);
	__g_list_free_g_free0 (_tmp2_);
	_g_free0 (path);
	_g_object_unref0 (file);
	_g_object_unref0 (mount);
}


static void _lambda7_ (GObject* o, GAsyncResult* r, DejaDupBackendFile* self) {
	GError * _inner_error_;
	g_return_if_fail (r != NULL);
	_inner_error_ = NULL;
	{
		gboolean success;
		GList* _tmp0_;
		success = g_file_mount_enclosing_volume_finish (G_FILE (o), r, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
				goto __catch2_g_io_error_permission_denied;
			}
			goto __catch2_g_error;
			goto __finally2;
		}
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", success, _tmp0_ = NULL, NULL);
		__g_list_free_g_free0 (_tmp0_);
	}
	goto __finally2;
	__catch2_g_io_error_permission_denied:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name ((DejaDupBackend*) self, "need-password");
			_g_error_free0 (e);
			return;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GList* _tmp1_;
			g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp1_ = NULL, e->message);
			__g_list_free_g_free0 (_tmp1_);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda7_ (source_object, res, self);
}


static void deja_dup_backend_file_check_if_password_needed (DejaDupBackendFile* self, GFile* file) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_file_mount_enclosing_volume (file, G_MOUNT_MOUNT_NONE, NULL, NULL, __lambda7__gasync_ready_callback, self);
}


static void _lambda8_ (GObject* o, GAsyncResult* r, DejaDupBackendFile* self) {
	GError * _inner_error_;
	g_return_if_fail (r != NULL);
	_inner_error_ = NULL;
	{
		gboolean success;
		GList* _tmp0_;
		success = g_file_mount_enclosing_volume_finish (G_FILE (o), r, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", success, _tmp0_ = NULL, NULL);
		__g_list_free_g_free0 (_tmp0_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GList* _tmp1_;
			g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp1_ = NULL, e->message);
			__g_list_free_g_free0 (_tmp1_);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda8_ (source_object, res, self);
}


static void deja_dup_backend_file_real_ask_password (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	GError * _inner_error_;
	char* path;
	GFile* file;
	GMountOperation* op;
	self = (DejaDupBackendFile*) base;
	_inner_error_ = NULL;
	path = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = deja_dup_backend_file_get_location_from_gconf (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
		path = (_tmp1_ = _tmp0_, _g_free0 (path), _tmp1_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GList* _tmp2_;
			g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp2_ = NULL, e->message);
			__g_list_free_g_free0 (_tmp2_);
			_g_error_free0 (e);
			_g_free0 (path);
			return;
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	file = _g_object_ref0 (g_file_parse_name (path));
	op = hacks_mount_operation_new (deja_dup_backend_get_toplevel ((DejaDupBackend*) self));
	g_file_mount_enclosing_volume (file, G_MOUNT_MOUNT_NONE, op, NULL, __lambda8__gasync_ready_callback, self);
	_g_free0 (path);
	_g_object_unref0 (file);
	_g_object_unref0 (op);
}


static void deja_dup_backend_file_class_init (DejaDupBackendFileClass * klass) {
	deja_dup_backend_file_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_file_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_file_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_file_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_file_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_file_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->ask_password = deja_dup_backend_file_real_ask_password;
}


static void deja_dup_backend_file_instance_init (DejaDupBackendFile * self) {
}


GType deja_dup_backend_file_get_type (void) {
	static GType deja_dup_backend_file_type_id = 0;
	if (deja_dup_backend_file_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendFile), 0, (GInstanceInitFunc) deja_dup_backend_file_instance_init, NULL };
		deja_dup_backend_file_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendFile", &g_define_type_info, 0);
	}
	return deja_dup_backend_file_type_id;
}




