/* AssistantOperation.c generated by valac, the Vala compiler
 * generated from AssistantOperation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <deja-dup.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <hacks.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gconf/gconf-client.h>


#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AssistantOperation {
	GtkAssistant parent_instance;
	AssistantOperationPrivate * priv;
	GtkLabel* summary_label;
};

struct _AssistantOperationClass {
	GtkAssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	char* (*get_progress_file_prefix) (AssistantOperation* self);
	GdkPixbuf* (*make_op_icon) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, DejaDupOperation* op, const char* _error_, const char* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*do_prepare) (AssistantOperation* self, GtkAssistant* assist, GtkWidget* page);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantOperationPrivate {
	GtkWidget* _confirm_page;
	GtkLabel* progress_label;
	GtkLabel* progress_file_label;
	GtkProgressBar* progress_bar;
	GtkTextView* progress_text;
	GtkScrolledWindow* progress_scroll;
	GtkWidget* _progress_page;
	GtkWidget* error_widget;
	GtkTextView* error_text_view;
	GtkWidget* _summary_page;
	GdkPixbuf* _op_icon;
	DejaDupOperation* op;
	guint timeout_id;
	gboolean _error_occurred;
	gboolean gives_progress;
	gboolean adjustment_at_end;
};


static gpointer assistant_operation_parent_class = NULL;

GType assistant_operation_get_type (void);
#define ASSISTANT_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_OPERATION, AssistantOperationPrivate))
enum  {
	ASSISTANT_OPERATION_DUMMY_PROPERTY,
	ASSISTANT_OPERATION_CONFIRM_PAGE,
	ASSISTANT_OPERATION_PROGRESS_PAGE,
	ASSISTANT_OPERATION_SUMMARY_PAGE,
	ASSISTANT_OPERATION_OP_ICON,
	ASSISTANT_OPERATION_ERROR_OCCURRED
};
GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self);
void assistant_operation_add_setup_pages (AssistantOperation* self);
static void assistant_operation_real_add_setup_pages (AssistantOperation* self);
void assistant_operation_add_custom_config_pages (AssistantOperation* self);
static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self);
DejaDupOperation* assistant_operation_create_op (AssistantOperation* self);
static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self);
char* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
static char* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self);
GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self);
static GdkPixbuf* assistant_operation_real_make_op_icon (AssistantOperation* self);
static gboolean assistant_operation_pulse (AssistantOperation* self);
static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, double percent);
static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const char* label);
static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file);
static void _lambda0_ (GtkAdjustment* a, AssistantOperation* self);
static void __lambda0__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void _lambda1_ (GtkAdjustment* a, AssistantOperation* self);
static void __lambda1__gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self);
static void assistant_operation_make_adjustment_stay_at_end (AssistantOperation* self, GtkWidget* range);
static void _assistant_operation_make_adjustment_stay_at_end_gtk_widget_realize (GtkWidget* _sender, gpointer self);
GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self);
static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
void assistant_operation_show_error (AssistantOperation* self, DejaDupOperation* op, const char* _error_, const char* detail);
static void assistant_operation_real_show_error (AssistantOperation* self, DejaDupOperation* op, const char* _error_, const char* detail);
GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self);
static void assistant_operation_add_config_pages_if_needed (AssistantOperation* self);
GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self);
static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_confirm_page (AssistantOperation* self);
static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_progress_page (AssistantOperation* self);
static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_summary_page (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
void assistant_operation_do_close (AssistantOperation* self);
static void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success);
static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gpointer self);
static void _assistant_operation_show_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self);
static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self);
static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gpointer self);
static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self);
static void assistant_operation_do_apply (AssistantOperation* self);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static gboolean _assistant_operation_pulse_gsource_func (gpointer self);
void assistant_operation_do_prepare (AssistantOperation* self, GtkAssistant* assist, GtkWidget* page);
static void assistant_operation_real_do_prepare (AssistantOperation* self, GtkAssistant* assist, GtkWidget* page);
static void assistant_operation_do_cancel (AssistantOperation* self);
static void assistant_operation_real_do_close (AssistantOperation* self);
AssistantOperation* assistant_operation_construct (GType object_type);
static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value);
static void _assistant_operation_do_apply_gtk_assistant_apply (GtkAssistant* _sender, gpointer self);
static void _assistant_operation_do_cancel_gtk_assistant_cancel (GtkAssistant* _sender, gpointer self);
static void _assistant_operation_do_close_gtk_assistant_close (GtkAssistant* _sender, gpointer self);
static void _assistant_operation_do_prepare_gtk_assistant_prepare (GtkAssistant* _sender, GtkWidget* page, gpointer self);
static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void assistant_operation_finalize (GObject* obj);
static void assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_make_confirm_page'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_confirm_page (self);
}


static void assistant_operation_real_add_setup_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_setup_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_setup_pages (self);
}


static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_custom_config_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_custom_config_pages (self);
}


static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_create_op'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupOperation* assistant_operation_create_op (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->create_op (self);
}


static char* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_progress_file_prefix'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* assistant_operation_get_progress_file_prefix (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->get_progress_file_prefix (self);
}


static GdkPixbuf* assistant_operation_real_make_op_icon (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_make_op_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_op_icon (self);
}


static gboolean assistant_operation_pulse (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->gives_progress) {
		gtk_progress_bar_pulse (self->priv->progress_bar);
	}
	result = TRUE;
	return result;
}


static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, double percent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	gtk_progress_bar_set_fraction (self->priv->progress_bar, percent);
	self->priv->gives_progress = TRUE;
}


static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const char* label) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (label != NULL);
	gtk_label_set_label (self->priv->progress_label, label);
	gtk_label_set_label (self->priv->progress_file_label, "");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file) {
	char* parse_name;
	char* basename;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	GtkTextBuffer* buffer;
	gboolean _tmp4_ = FALSE;
	GtkTextIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (file != NULL);
	parse_name = g_file_get_parse_name (file);
	basename = g_path_get_basename (parse_name);
	gtk_label_set_label (self->priv->progress_label, _tmp1_ = g_strconcat (_tmp0_ = assistant_operation_get_progress_file_prefix (self), " ", NULL));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	gtk_label_set_label (self->priv->progress_file_label, _tmp2_ = g_strdup_printf ("'%s'", basename));
	_g_free0 (_tmp2_);
	buffer = _g_object_ref0 (gtk_text_view_get_buffer (self->priv->progress_text));
	if (gtk_text_buffer_get_char_count (buffer) > 0) {
		char* _tmp3_;
		parse_name = (_tmp3_ = g_strconcat ("\n", parse_name, NULL), _g_free0 (parse_name), _tmp3_);
	}
	if (gtk_text_buffer_get_line_count (buffer) >= 100) {
		_tmp4_ = self->priv->adjustment_at_end;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkTextIter start = {0};
		GtkTextIter line100 = {0};
		gtk_text_buffer_get_start_iter (buffer, &start);
		gtk_text_buffer_get_iter_at_line (buffer, &line100, gtk_text_buffer_get_line_count (buffer) - 100);
		gtk_text_buffer_delete (buffer, &start, &line100);
	}
	gtk_text_buffer_get_end_iter (buffer, &iter);
	g_signal_emit_by_name (buffer, "insert-text", &iter, parse_name, -1);
	_g_free0 (parse_name);
	_g_free0 (basename);
	_g_object_unref0 (buffer);
}


static void _lambda0_ (GtkAdjustment* a, AssistantOperation* self) {
	g_return_if_fail (a != NULL);
	self->priv->adjustment_at_end = gtk_adjustment_get_value (a) >= (hacks_adjustment_get_upper (a) - hacks_adjustment_get_page_size (a));
}


static void __lambda0__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (GtkAdjustment* a, AssistantOperation* self) {
	g_return_if_fail (a != NULL);
	if (self->priv->adjustment_at_end) {
		gtk_adjustment_set_value (a, hacks_adjustment_get_upper (a));
	}
}


static void __lambda1__gtk_adjustment_changed (GtkAdjustment* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void assistant_operation_make_adjustment_stay_at_end (AssistantOperation* self, GtkWidget* range) {
	GtkAdjustment* adjust;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	adjust = _g_object_ref0 (gtk_range_get_adjustment (GTK_RANGE (range)));
	g_signal_connect_object (adjust, "value-changed", (GCallback) __lambda0__gtk_adjustment_value_changed, self, 0);
	g_signal_connect_object (adjust, "changed", (GCallback) __lambda1__gtk_adjustment_changed, self, 0);
	_g_object_unref0 (adjust);
}


static void _assistant_operation_make_adjustment_stay_at_end_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	assistant_operation_make_adjustment_stay_at_end (self, _sender);
}


static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkHBox* progress_hbox;
	GtkProgressBar* _tmp2_;
	GtkTextView* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkRange* range;
	GtkExpander* expander;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->progress_label = (_tmp0_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->progress_label), _tmp0_);
	g_object_set ((GObject*) self->priv->progress_label, "xalign", 0.0f, NULL);
	self->priv->progress_file_label = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->progress_file_label), _tmp1_);
	g_object_set ((GObject*) self->priv->progress_file_label, "xalign", 0.0f, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
	progress_hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	g_object_set ((GObject*) progress_hbox, "child", self->priv->progress_label, "child", self->priv->progress_file_label, NULL);
	gtk_container_child_set ((GtkContainer*) progress_hbox, (GtkWidget*) self->priv->progress_label, "expand", FALSE, NULL);
	self->priv->progress_bar = (_tmp2_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->progress_bar), _tmp2_);
	self->priv->progress_text = (_tmp3_ = g_object_ref_sink ((GtkTextView*) gtk_text_view_new ()), _g_object_unref0 (self->priv->progress_text), _tmp3_);
	gtk_text_view_set_editable (self->priv->progress_text, FALSE);
	self->priv->progress_scroll = (_tmp4_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (self->priv->progress_scroll), _tmp4_);
	g_object_set ((GObject*) self->priv->progress_scroll, "child", self->priv->progress_text, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, "border-width", 6, NULL);
	range = _g_object_ref0 (GTK_RANGE (self->priv->progress_scroll->vscrollbar));
	g_signal_connect_object ((GtkWidget*) range, "realize", (GCallback) _assistant_operation_make_adjustment_stay_at_end_gtk_widget_realize, self, 0);
	expander = g_object_ref_sink ((GtkExpander*) gtk_expander_new_with_mnemonic (_ ("_Details")));
	g_object_set ((GObject*) expander, "child", self->priv->progress_scroll, NULL);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", progress_hbox, "child", self->priv->progress_bar, "child", expander, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) progress_hbox, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->progress_bar, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (progress_hbox);
	_g_object_unref0 (range);
	_g_object_unref0 (expander);
	return result;
}


GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_progress_page (self);
}


static void assistant_operation_real_show_error (AssistantOperation* self, DejaDupOperation* op, const char* _error_, const char* detail) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (_error_ != NULL);
	_inner_error_ = NULL;
	assistant_operation_set_error_occurred (self, TRUE);
	{
		GdkPixbuf* pixbuf;
		pixbuf = hacks_get_icon_at_size (GTK_STOCK_DIALOG_ERROR, 48, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		gtk_container_child_set ((GtkContainer*) self, self->priv->_summary_page, "header-image", pixbuf, NULL);
		_g_object_unref0 (pixbuf);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_label_set_label (self->summary_label, _error_);
	g_object_set (self->summary_label, "wrap", TRUE, NULL);
	gtk_label_set_selectable (self->summary_label, TRUE);
	if (detail != NULL) {
		gtk_widget_set_no_show_all (self->priv->error_widget, FALSE);
		gtk_widget_show_all (self->priv->error_widget);
		gtk_text_buffer_set_text (gtk_text_view_get_buffer (self->priv->error_text_view), detail, -1);
	}
	gtk_assistant_set_current_page ((GtkAssistant*) self, gtk_assistant_get_n_pages ((GtkAssistant*) self) - 1);
}


void assistant_operation_show_error (AssistantOperation* self, DejaDupOperation* op, const char* _error_, const char* detail) {
	ASSISTANT_OPERATION_GET_CLASS (self)->show_error (self, op, _error_, detail);
}


static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self) {
	GtkWidget* result;
	GtkLabel* _tmp0_;
	GtkTextView* _tmp1_;
	GtkScrolledWindow* scroll;
	GtkWidget* _tmp2_;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	self->summary_label = (_tmp0_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->summary_label), _tmp0_);
	g_object_set ((GObject*) self->summary_label, "xalign", 0.0f, NULL);
	self->priv->error_text_view = (_tmp1_ = g_object_ref_sink ((GtkTextView*) gtk_text_view_new ()), _g_object_unref0 (self->priv->error_text_view), _tmp1_);
	gtk_text_view_set_editable (self->priv->error_text_view, FALSE);
	gtk_text_view_set_wrap_mode (self->priv->error_text_view, GTK_WRAP_WORD);
	g_object_set ((GtkWidget*) self->priv->error_text_view, "height-request", 150, NULL);
	scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->error_text_view);
	gtk_widget_set_no_show_all ((GtkWidget*) scroll, TRUE);
	self->priv->error_widget = (_tmp2_ = _g_object_ref0 ((GtkWidget*) scroll), _g_object_unref0 (self->priv->error_widget), _tmp2_);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", self->summary_label, "child", self->priv->error_widget, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->summary_label, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (scroll);
	return result;
}


GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_summary_page (self);
}


static void assistant_operation_add_config_pages_if_needed (AssistantOperation* self) {
	GError * _inner_error_;
	GConfClient* client;
	char* val;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	val = NULL;
	{
		const char* _tmp0_;
		char* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp0_ = gconf_client_get_string (client, DEJA_DUP_LAST_RUN_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		val = (_tmp1_ = g_strdup (_tmp0_), _g_free0 (val), _tmp1_);
		if (val != NULL) {
			_tmp2_ = _vala_strcmp0 (val, "") != 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_g_object_unref0 (client);
			_g_free0 (val);
			return;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("AssistantOperation.vala:222: %s\n", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (client);
			_g_free0 (val);
			return;
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	assistant_operation_add_custom_config_pages (self);
	_g_object_unref0 (client);
	_g_free0 (val);
}


static void assistant_operation_add_confirm_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_confirm_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "title", _ ("Summary"), "page-type", GTK_ASSISTANT_PAGE_CONFIRM, "complete", TRUE, "header-image", self->priv->_op_icon, NULL);
	assistant_operation_set_confirm_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_progress_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_progress_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "page-type", GTK_ASSISTANT_PAGE_CONTENT, "header-image", self->priv->_op_icon, NULL);
	assistant_operation_set_progress_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_summary_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_summary_page (self);
	gtk_assistant_append_page ((GtkAssistant*) self, page);
	gtk_container_child_set ((GtkContainer*) self, page, "page-type", GTK_ASSISTANT_PAGE_SUMMARY, "complete", TRUE, "header-image", self->priv->_op_icon, NULL);
	assistant_operation_set_summary_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success) {
	DejaDupOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	self->priv->op = (_tmp0_ = NULL, _g_object_unref0 (self->priv->op), _tmp0_);
	if (success) {
		gtk_assistant_set_current_page ((GtkAssistant*) self, gtk_assistant_get_n_pages ((GtkAssistant*) self) - 1);
	} else {
		if (!self->priv->_error_occurred) {
			assistant_operation_do_close (self);
		}
	}
}


static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gpointer self) {
	assistant_operation_apply_finished (self, _sender, success);
}


static void _assistant_operation_show_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self) {
	assistant_operation_show_error (self, _sender, errstr, detail);
}


static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self) {
	assistant_operation_set_progress_label (self, _sender, action);
}


static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gpointer self) {
	assistant_operation_set_progress_label_file (self, _sender, file);
}


static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self) {
	assistant_operation_show_progress (self, _sender, percent);
}


static void assistant_operation_do_apply (AssistantOperation* self) {
	GError * _inner_error_;
	DejaDupOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	self->priv->op = (_tmp0_ = assistant_operation_create_op (self), _g_object_unref0 (self->priv->op), _tmp0_);
	g_signal_connect_object (self->priv->op, "done", (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self, 0);
	g_signal_connect_object (self->priv->op, "raise-error", (GCallback) _assistant_operation_show_error_deja_dup_operation_raise_error, self, 0);
	g_signal_connect_object (self->priv->op, "action-desc-changed", (GCallback) _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed, self, 0);
	g_signal_connect_object (self->priv->op, "action-file-changed", (GCallback) _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed, self, 0);
	g_signal_connect_object (self->priv->op, "progress", (GCallback) _assistant_operation_show_progress_deja_dup_operation_progress, self, 0);
	{
		deja_dup_operation_start (self->priv->op, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("AssistantOperation.vala:290: %s\n", e->message);
			assistant_operation_show_error (self, self->priv->op, e->message, NULL);
			assistant_operation_apply_finished (self, self->priv->op, FALSE);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _assistant_operation_pulse_gsource_func (gpointer self) {
	return assistant_operation_pulse (self);
}


static void assistant_operation_real_do_prepare (AssistantOperation* self, GtkAssistant* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	if (page == self->priv->_confirm_page) {
		if (self->priv->op != NULL) {
			guint _tmp0_;
			DejaDupOperation* _tmp1_;
			g_signal_handlers_disconnect_matched (self->priv->op, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self);
			deja_dup_operation_cancel (self->priv->op);
			self->priv->op = (_tmp1_ = NULL, _g_object_unref0 (self->priv->op), _tmp1_);
		}
	} else {
		if (page == self->priv->_progress_page) {
			gtk_progress_bar_set_fraction (self->priv->progress_bar, (double) 0);
			self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_operation_pulse_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}


void assistant_operation_do_prepare (AssistantOperation* self, GtkAssistant* assist, GtkWidget* page) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_prepare (self, assist, page);
}


static void assistant_operation_do_cancel (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->op != NULL) {
		deja_dup_operation_cancel (self->priv->op);
	} else {
		assistant_operation_do_close (self);
	}
}


static void assistant_operation_real_do_close (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	gtk_object_destroy ((GtkObject*) self);
}


void assistant_operation_do_close (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_close (self);
}


AssistantOperation* assistant_operation_construct (GType object_type) {
	AssistantOperation * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_confirm_page;
	return result;
}


static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_confirm_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_confirm_page), _tmp0_);
	g_object_notify ((GObject *) self, "confirm-page");
}


GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_progress_page;
	return result;
}


static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_progress_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_progress_page), _tmp0_);
	g_object_notify ((GObject *) self, "progress-page");
}


GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_summary_page;
	return result;
}


static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_summary_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_summary_page), _tmp0_);
	g_object_notify ((GObject *) self, "summary-page");
}


GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_op_icon;
	return result;
}


static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_op_icon = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_op_icon), _tmp0_);
	g_object_notify ((GObject *) self, "op-icon");
}


gboolean assistant_operation_get_error_occurred (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_occurred;
	return result;
}


static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error_occurred = value;
	g_object_notify ((GObject *) self, "error-occurred");
}


static void _assistant_operation_do_apply_gtk_assistant_apply (GtkAssistant* _sender, gpointer self) {
	assistant_operation_do_apply (self);
}


static void _assistant_operation_do_cancel_gtk_assistant_cancel (GtkAssistant* _sender, gpointer self) {
	assistant_operation_do_cancel (self);
}


static void _assistant_operation_do_close_gtk_assistant_close (GtkAssistant* _sender, gpointer self) {
	assistant_operation_do_close (self);
}


static void _assistant_operation_do_prepare_gtk_assistant_prepare (GtkAssistant* _sender, GtkWidget* page, gpointer self) {
	assistant_operation_do_prepare (self, _sender, page);
}


static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantOperation * self;
	parent_class = G_OBJECT_CLASS (assistant_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_OPERATION (obj);
	{
		GdkPixbuf* _tmp0_;
		assistant_operation_set_op_icon (self, _tmp0_ = assistant_operation_make_op_icon (self));
		_g_object_unref0 (_tmp0_);
		assistant_operation_add_config_pages_if_needed (self);
		assistant_operation_add_setup_pages (self);
		assistant_operation_add_confirm_page (self);
		assistant_operation_add_progress_page (self);
		assistant_operation_add_summary_page (self);
		g_signal_connect_object ((GtkAssistant*) self, "apply", (GCallback) _assistant_operation_do_apply_gtk_assistant_apply, self, 0);
		g_signal_connect_object ((GtkAssistant*) self, "cancel", (GCallback) _assistant_operation_do_cancel_gtk_assistant_cancel, self, 0);
		g_signal_connect_object ((GtkAssistant*) self, "close", (GCallback) _assistant_operation_do_close_gtk_assistant_close, self, 0);
		g_signal_connect_object ((GtkAssistant*) self, "prepare", (GCallback) _assistant_operation_do_prepare_gtk_assistant_prepare, self, 0);
	}
	return obj;
}


static void assistant_operation_class_init (AssistantOperationClass * klass) {
	assistant_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantOperationPrivate));
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_operation_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_operation_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_operation_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_operation_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_operation_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->make_op_icon = assistant_operation_real_make_op_icon;
	ASSISTANT_OPERATION_CLASS (klass)->make_progress_page = assistant_operation_real_make_progress_page;
	ASSISTANT_OPERATION_CLASS (klass)->show_error = assistant_operation_real_show_error;
	ASSISTANT_OPERATION_CLASS (klass)->make_summary_page = assistant_operation_real_make_summary_page;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_operation_real_do_prepare;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_operation_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = assistant_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = assistant_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONFIRM_PAGE, g_param_spec_object ("confirm-page", "confirm-page", "confirm-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PROGRESS_PAGE, g_param_spec_object ("progress-page", "progress-page", "progress-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_SUMMARY_PAGE, g_param_spec_object ("summary-page", "summary-page", "summary-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_OP_ICON, g_param_spec_object ("op-icon", "op-icon", "op-icon", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ERROR_OCCURRED, g_param_spec_boolean ("error-occurred", "error-occurred", "error-occurred", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void assistant_operation_instance_init (AssistantOperation * self) {
	self->priv = ASSISTANT_OPERATION_GET_PRIVATE (self);
	self->priv->adjustment_at_end = TRUE;
}


static void assistant_operation_finalize (GObject* obj) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (obj);
	_g_object_unref0 (self->priv->_confirm_page);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->progress_file_label);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->progress_text);
	_g_object_unref0 (self->priv->progress_scroll);
	_g_object_unref0 (self->priv->_progress_page);
	_g_object_unref0 (self->summary_label);
	_g_object_unref0 (self->priv->error_widget);
	_g_object_unref0 (self->priv->error_text_view);
	_g_object_unref0 (self->priv->_summary_page);
	_g_object_unref0 (self->priv->_op_icon);
	_g_object_unref0 (self->priv->op);
	G_OBJECT_CLASS (assistant_operation_parent_class)->finalize (obj);
}


GType assistant_operation_get_type (void) {
	static GType assistant_operation_type_id = 0;
	if (assistant_operation_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantOperation), 0, (GInstanceInitFunc) assistant_operation_instance_init, NULL };
		assistant_operation_type_id = g_type_register_static (GTK_TYPE_ASSISTANT, "AssistantOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return assistant_operation_type_id;
}


static void assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		g_value_set_object (value, assistant_operation_get_confirm_page (self));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		g_value_set_object (value, assistant_operation_get_progress_page (self));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		g_value_set_object (value, assistant_operation_get_summary_page (self));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		g_value_set_object (value, assistant_operation_get_op_icon (self));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		g_value_set_boolean (value, assistant_operation_get_error_occurred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		assistant_operation_set_confirm_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		assistant_operation_set_progress_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		assistant_operation_set_summary_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		assistant_operation_set_op_icon (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		assistant_operation_set_error_occurred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




