/* StatusIcon.c generated by valac, the Vala compiler
 * generated from StatusIcon.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup Applet
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <deja-dup.h>
#include <libnotify/notify.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <hacks.h>
#include <config.h>


#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
typedef struct _StatusIconPrivate StatusIconPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _StatusIcon {
	GtkStatusIcon parent_instance;
	StatusIconPrivate * priv;
};

struct _StatusIconClass {
	GtkStatusIconClass parent_class;
};

struct _StatusIconPrivate {
	DejaDupOperationBackup* op;
	NotifyNotification* note;
	gboolean need_passphrase;
	gboolean fatal_error;
	double progress;
	char* action;
};


static gpointer status_icon_parent_class = NULL;

GType status_icon_get_type (void);
#define STATUS_ICON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATUS_ICON, StatusIconPrivate))
enum  {
	STATUS_ICON_DUMMY_PROPERTY
};
static void status_icon_send_done (StatusIcon* self, DejaDupOperation* op, gboolean success);
static void status_icon_update_tooltip (StatusIcon* self);
static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const char* action);
static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, double percent);
static void status_icon_start (StatusIcon* self, gboolean warn);
static gboolean status_icon_start_idle (StatusIcon* self);
static void _status_icon_send_done_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gpointer self);
static gboolean status_icon_notify_passphrase (StatusIcon* self, DejaDupOperation* op);
static gboolean _status_icon_notify_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static gboolean status_icon_notify_backend_password (StatusIcon* self, DejaDupOperation* op);
static gboolean _status_icon_notify_backend_password_deja_dup_operation_backend_password_required (DejaDupOperation* _sender, gpointer self);
static void status_icon_notify_error (StatusIcon* self, DejaDupOperation* op, const char* errstr, const char* detail);
static void _status_icon_notify_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self);
static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self);
static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self);
static void status_icon_notify_start (StatusIcon* self);
static void status_icon_begin_backup (StatusIcon* self);
static gboolean status_icon_can_display_actions (StatusIcon* self);
static void status_icon_skip (StatusIcon* self, NotifyNotification* note, const char* action);
static void _status_icon_skip_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self);
static void status_icon_later (StatusIcon* self, NotifyNotification* note, const char* action);
static void _status_icon_later_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self);
static void _status_icon_begin_backup_notify_notification_closed (NotifyNotification* _sender, gpointer self);
static void status_icon_activate_enter (StatusIcon* self);
static void _status_icon_activate_enter_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void status_icon_enter (StatusIcon* self, NotifyNotification* note, const char* action);
static void _status_icon_enter_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self);
static void status_icon_rerun (StatusIcon* self, NotifyNotification* note, const char* action);
static void _status_icon_rerun_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self);
static void status_icon_error_closed (StatusIcon* self, NotifyNotification* note);
static void _status_icon_error_closed_notify_notification_closed (NotifyNotification* _sender, gpointer self);
static void status_icon_end_notify (StatusIcon* self, NotifyNotification* note);
static void status_icon_later_clicked (StatusIcon* self, GtkMenuItem* item);
static void _status_icon_later_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void status_icon_skip_clicked (StatusIcon* self, GtkMenuItem* item);
static void _status_icon_skip_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void status_icon_preferences_clicked (StatusIcon* self, GtkMenuItem* item);
static void _status_icon_preferences_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void status_icon_about_clicked (StatusIcon* self, GtkMenuItem* item);
static void _status_icon_about_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void status_icon_show_menu (StatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
StatusIcon* status_icon_new (void);
StatusIcon* status_icon_construct (GType object_type);
static gboolean _status_icon_start_idle_gsource_func (gpointer self);
static void _status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void status_icon_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void status_icon_send_done (StatusIcon* self, DejaDupOperation* op, gboolean success) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_signal_emit_by_name (self, "done");
}


static void status_icon_set_action_desc (StatusIcon* self, DejaDupOperation* op, const char* action) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (action != NULL);
	self->priv->action = (_tmp0_ = g_strdup (action), _g_free0 (self->priv->action), _tmp0_);
	status_icon_update_tooltip (self);
}


static void status_icon_note_progress (StatusIcon* self, DejaDupOperation* op, double percent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	self->priv->progress = percent;
	status_icon_update_tooltip (self);
}


static void status_icon_update_tooltip (StatusIcon* self) {
	char* tooltip;
	g_return_if_fail (self != NULL);
	tooltip = g_strdup ("");
	if (self->priv->action != NULL) {
		char* _tmp0_;
		tooltip = (_tmp0_ = g_strdup (self->priv->action), _g_free0 (tooltip), _tmp0_);
	}
	if (self->priv->progress > 0) {
		char* _tmp3_;
		char* _tmp2_;
		char* _tmp1_;
		tooltip = (_tmp3_ = g_strconcat (_tmp1_ = g_strconcat (tooltip, "\n", NULL), _tmp2_ = g_strdup_printf (_ ("%.1f%% complete"), self->priv->progress * 100), NULL), _g_free0 (tooltip), _tmp3_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
	}
	hacks_status_icon_set_tooltip_text ((GtkStatusIcon*) self, tooltip);
	_g_free0 (tooltip);
}


static gboolean status_icon_start_idle (StatusIcon* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	status_icon_start (self, TRUE);
	result = FALSE;
	return result;
}


static void _status_icon_send_done_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gpointer self) {
	status_icon_send_done (self, _sender, success);
}


static gboolean _status_icon_notify_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	return status_icon_notify_passphrase (self, _sender);
}


static gboolean _status_icon_notify_backend_password_deja_dup_operation_backend_password_required (DejaDupOperation* _sender, gpointer self) {
	return status_icon_notify_backend_password (self, _sender);
}


static void _status_icon_notify_error_deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self) {
	status_icon_notify_error (self, _sender, errstr, detail);
}


static void _status_icon_set_action_desc_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self) {
	status_icon_set_action_desc (self, _sender, action);
}


static void _status_icon_note_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self) {
	status_icon_note_progress (self, _sender, percent);
}


static void status_icon_start (StatusIcon* self, gboolean warn) {
	DejaDupOperationBackup* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->need_passphrase = FALSE;
	self->priv->fatal_error = FALSE;
	self->priv->progress = (double) 0;
	self->priv->op = (_tmp0_ = deja_dup_operation_backup_new (NULL, (guint) hacks_status_icon_get_x11_window_id ((GtkStatusIcon*) self)), _g_object_unref0 (self->priv->op), _tmp0_);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "done", (GCallback) _status_icon_send_done_deja_dup_operation_done, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "passphrase-required", (GCallback) _status_icon_notify_passphrase_deja_dup_operation_passphrase_required, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "backend-password-required", (GCallback) _status_icon_notify_backend_password_deja_dup_operation_backend_password_required, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "raise-error", (GCallback) _status_icon_notify_error_deja_dup_operation_raise_error, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "action-desc-changed", (GCallback) _status_icon_set_action_desc_deja_dup_operation_action_desc_changed, self, 0);
	g_signal_connect_object ((DejaDupOperation*) self->priv->op, "progress", (GCallback) _status_icon_note_progress_deja_dup_operation_progress, self, 0);
	if (warn) {
		status_icon_notify_start (self);
	} else {
		status_icon_begin_backup (self);
	}
}


static void status_icon_begin_backup (StatusIcon* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		deja_dup_operation_start ((DejaDupOperation*) self->priv->op, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:108: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean status_icon_can_display_actions (StatusIcon* self) {
	gboolean result;
	GList* caps;
	g_return_val_if_fail (self != NULL, FALSE);
	caps = notify_get_server_caps ();
	{
		GList* cap_collection;
		GList* cap_it;
		cap_collection = caps;
		for (cap_it = cap_collection; cap_it != NULL; cap_it = cap_it->next) {
			char* cap;
			cap = g_strdup ((const char*) cap_it->data);
			{
				if (_vala_strcmp0 (cap, "actions") == 0) {
					result = TRUE;
					_g_free0 (cap);
					return result;
				}
				_g_free0 (cap);
			}
		}
	}
	result = FALSE;
	return result;
}


static void _status_icon_skip_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self) {
	status_icon_skip (self, p1, p2);
}


static void _status_icon_later_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self) {
	status_icon_later (self, p1, p2);
}


static void _status_icon_begin_backup_notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	status_icon_begin_backup (self);
}


static void status_icon_notify_start (StatusIcon* self) {
	GError * _inner_error_;
	NotifyNotification* _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	self->priv->note = (_tmp0_ = notify_notification_new_with_status_icon (_ ("Backup about to start"), _ ("A scheduled backup will shortly begin.  You can instead choose to backup later or not at all."), PACKAGE, (GtkStatusIcon*) self), _g_object_unref0 (self->priv->note), _tmp0_);
	if (status_icon_can_display_actions (self)) {
		notify_notification_add_action (self->priv->note, "skip", _ ("Skip Backup"), _status_icon_skip_notify_action_callback, g_object_ref (self), g_object_unref);
		notify_notification_add_action (self->priv->note, "later", _ ("Backup Later"), _status_icon_later_notify_action_callback, g_object_ref (self), g_object_unref);
	}
	g_signal_connect_object (self->priv->note, "closed", (GCallback) _status_icon_begin_backup_notify_notification_closed, self, 0);
	{
		notify_notification_show (self->priv->note, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:133: %s\n", e->message);
			status_icon_begin_backup (self);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _status_icon_activate_enter_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	status_icon_activate_enter (self);
}


static void _status_icon_enter_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self) {
	status_icon_enter (self, p1, p2);
}


static gboolean status_icon_notify_passphrase (StatusIcon* self, DejaDupOperation* op) {
	gboolean result;
	GError * _inner_error_;
	NotifyNotification* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (op != NULL, FALSE);
	_inner_error_ = NULL;
	self->priv->need_passphrase = TRUE;
	gtk_status_icon_set_blinking ((GtkStatusIcon*) self, TRUE);
	g_signal_connect_object ((GtkStatusIcon*) self, "activate", (GCallback) _status_icon_activate_enter_gtk_status_icon_activate, self, 0);
	self->priv->note = (_tmp0_ = notify_notification_new_with_status_icon (_ ("Encryption password needed"), _ ("Please enter the encryption password for your backup files."), "dialog-password", (GtkStatusIcon*) self), _g_object_unref0 (self->priv->note), _tmp0_);
	if (status_icon_can_display_actions (self)) {
		notify_notification_add_action (self->priv->note, "default", _ ("Enter"), _status_icon_enter_notify_action_callback, g_object_ref (self), g_object_unref);
	}
	{
		notify_notification_show (self->priv->note, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:152: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean status_icon_notify_backend_password (StatusIcon* self, DejaDupOperation* op) {
	gboolean result;
	GError * _inner_error_;
	NotifyNotification* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (op != NULL, FALSE);
	_inner_error_ = NULL;
	gtk_status_icon_set_blinking ((GtkStatusIcon*) self, TRUE);
	g_signal_connect_object ((GtkStatusIcon*) self, "activate", (GCallback) _status_icon_activate_enter_gtk_status_icon_activate, self, 0);
	self->priv->note = (_tmp0_ = notify_notification_new_with_status_icon (_ ("Server password needed"), _ ("Please enter the server password for your backup."), "dialog-password", (GtkStatusIcon*) self), _g_object_unref0 (self->priv->note), _tmp0_);
	if (status_icon_can_display_actions (self)) {
		notify_notification_add_action (self->priv->note, "default", _ ("Enter"), _status_icon_enter_notify_action_callback, g_object_ref (self), g_object_unref);
	}
	{
		notify_notification_show (self->priv->note, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:170: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void _status_icon_rerun_notify_action_callback (NotifyNotification* p1, const char* p2, gpointer self) {
	status_icon_rerun (self, p1, p2);
}


static void _status_icon_error_closed_notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	status_icon_error_closed (self, _sender);
}


static void status_icon_notify_error (StatusIcon* self, DejaDupOperation* op, const char* errstr, const char* detail) {
	GError * _inner_error_;
	NotifyNotification* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (errstr != NULL);
	_inner_error_ = NULL;
	self->priv->fatal_error = TRUE;
	self->priv->note = (_tmp0_ = notify_notification_new_with_status_icon (_ ("Backup error occurred"), errstr, "dialog-error", (GtkStatusIcon*) self), _g_object_unref0 (self->priv->note), _tmp0_);
	g_signal_handlers_disconnect_matched (op, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp1_, NULL, FALSE), _tmp1_), 0, NULL, (GCallback) _status_icon_send_done_deja_dup_operation_done, self);
	if (status_icon_can_display_actions (self)) {
		notify_notification_add_action (self->priv->note, "rerun", _ ("Rerun"), _status_icon_rerun_notify_action_callback, g_object_ref (self), g_object_unref);
		notify_notification_set_timeout (self->priv->note, NOTIFY_EXPIRES_NEVER);
	}
	g_signal_connect_object (self->priv->note, "closed", (GCallback) _status_icon_error_closed_notify_notification_closed, self, 0);
	{
		notify_notification_show (self->priv->note, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:194: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void status_icon_end_notify (StatusIcon* self, NotifyNotification* note) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_status_icon_set_blinking ((GtkStatusIcon*) self, FALSE);
	g_signal_handlers_disconnect_matched ((GtkStatusIcon*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("activate", GTK_TYPE_STATUS_ICON, &_tmp0_, NULL, FALSE), _tmp0_), 0, NULL, (GCallback) _status_icon_activate_enter_gtk_status_icon_activate, self);
}


static void status_icon_error_closed (StatusIcon* self, NotifyNotification* note) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (note != NULL);
	if (self->priv->fatal_error) {
		g_signal_emit_by_name (self, "done");
	}
}


static void status_icon_enter (StatusIcon* self, NotifyNotification* note, const char* action) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		if (self->priv->need_passphrase) {
			deja_dup_operation_ask_passphrase ((DejaDupOperation*) self->priv->op, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
				goto __finally5;
			}
			self->priv->need_passphrase = FALSE;
		} else {
			deja_dup_operation_ask_backend_password ((DejaDupOperation*) self->priv->op, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
				goto __finally5;
			}
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:220: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	status_icon_end_notify (self, note);
}


static void status_icon_activate_enter (StatusIcon* self) {
	g_return_if_fail (self != NULL);
	status_icon_enter (self, self->priv->note, NULL);
}


static void status_icon_rerun (StatusIcon* self, NotifyNotification* note, const char* action) {
	g_return_if_fail (self != NULL);
	self->priv->fatal_error = FALSE;
	status_icon_start (self, FALSE);
}


static void status_icon_later (StatusIcon* self, NotifyNotification* note, const char* action) {
	g_return_if_fail (self != NULL);
	status_icon_end_notify (self, note);
	deja_dup_operation_cancel ((DejaDupOperation*) self->priv->op);
}


static void status_icon_skip (StatusIcon* self, NotifyNotification* note, const char* action) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		deja_dup_update_last_run_timestamp (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
			goto __finally6;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("StatusIcon.vala:249: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	status_icon_end_notify (self, note);
	deja_dup_operation_cancel ((DejaDupOperation*) self->priv->op);
}


static void _status_icon_later_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_later_clicked (self, _sender);
}


static void _status_icon_skip_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_skip_clicked (self, _sender);
}


static void _status_icon_preferences_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_preferences_clicked (self, _sender);
}


static void _status_icon_about_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	status_icon_about_clicked (self, _sender);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void status_icon_show_menu (StatusIcon* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	GtkMenu* menu;
	GtkMenuItem* item;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	menu = g_object_ref_sink ((GtkMenu*) gtk_menu_new ());
	item = NULL;
	item = (_tmp0_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Backup _Later"))), _g_object_unref0 (item), _tmp0_);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_later_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	item = (_tmp1_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Skip Backup"))), _g_object_unref0 (item), _tmp1_);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_skip_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	item = (_tmp2_ = (GtkMenuItem*) g_object_ref_sink ((GtkSeparatorMenuItem*) gtk_separator_menu_item_new ()), _g_object_unref0 (item), _tmp2_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	item = (_tmp3_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL)), _g_object_unref0 (item), _tmp3_);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_preferences_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	item = (_tmp4_ = (GtkMenuItem*) g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL)), _g_object_unref0 (item), _tmp4_);
	g_signal_connect_object (item, "activate", (GCallback) _status_icon_about_clicked_gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	gtk_widget_show_all ((GtkWidget*) menu);
	gtk_menu_popup (menu, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, (GtkStatusIcon*) self, button, (guint32) activate_time);
	_g_object_unref0 (menu);
	_g_object_unref0 (item);
}


static void status_icon_later_clicked (StatusIcon* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	status_icon_later (self, self->priv->note, NULL);
}


static void status_icon_skip_clicked (StatusIcon* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	status_icon_skip (self, self->priv->note, NULL);
}


static void status_icon_about_clicked (StatusIcon* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	deja_dup_show_about ((GObject*) self, NULL);
}


static void status_icon_preferences_clicked (StatusIcon* self, GtkMenuItem* item) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_inner_error_ = NULL;
	{
		g_spawn_command_line_async ("deja-dup-preferences", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
			goto __finally7;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* dlg;
			dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not open preferences")));
			gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) dlg);
			gtk_object_destroy ((GtkObject*) dlg);
			_g_error_free0 (e);
			_g_object_unref0 (dlg);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


StatusIcon* status_icon_construct (GType object_type) {
	StatusIcon * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


StatusIcon* status_icon_new (void) {
	return status_icon_construct (TYPE_STATUS_ICON);
}


static gboolean _status_icon_start_idle_gsource_func (gpointer self) {
	return status_icon_start_idle (self);
}


static void _status_icon_show_menu_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	status_icon_show_menu (self, _sender, button, activate_time);
}


static GObject * status_icon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	StatusIcon * self;
	parent_class = G_OBJECT_CLASS (status_icon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = STATUS_ICON (obj);
	{
		g_object_set ((GtkStatusIcon*) self, "icon-name", PACKAGE, NULL);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _status_icon_start_idle_gsource_func, g_object_ref (self), g_object_unref);
		g_signal_connect_object ((GtkStatusIcon*) self, "popup-menu", (GCallback) _status_icon_show_menu_gtk_status_icon_popup_menu, self, 0);
	}
	return obj;
}


static void status_icon_class_init (StatusIconClass * klass) {
	status_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StatusIconPrivate));
	G_OBJECT_CLASS (klass)->constructor = status_icon_constructor;
	G_OBJECT_CLASS (klass)->finalize = status_icon_finalize;
	g_signal_new ("done", TYPE_STATUS_ICON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void status_icon_instance_init (StatusIcon * self) {
	self->priv = STATUS_ICON_GET_PRIVATE (self);
}


static void status_icon_finalize (GObject* obj) {
	StatusIcon * self;
	GError * _inner_error_;
	self = STATUS_ICON (obj);
	_inner_error_ = NULL;
	{
		if (self->priv->note != NULL) {
			{
				notify_notification_close (self->priv->note, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch8_g_error;
					goto __finally8;
				}
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("StatusIcon.vala:46: %s\n", e->message);
					_g_error_free0 (e);
				}
			}
			__finally8:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
			}
		}
	}
	_g_object_unref0 (self->priv->op);
	_g_object_unref0 (self->priv->note);
	_g_free0 (self->priv->action);
	G_OBJECT_CLASS (status_icon_parent_class)->finalize (obj);
}


GType status_icon_get_type (void) {
	static GType status_icon_type_id = 0;
	if (status_icon_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (StatusIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusIcon), 0, (GInstanceInitFunc) status_icon_instance_init, NULL };
		status_icon_type_id = g_type_register_static (GTK_TYPE_STATUS_ICON, "StatusIcon", &g_define_type_info, 0);
	}
	return status_icon_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




