#!/usr/bin/env python

# This file is part of Atabake
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Authors: Artur Duque de Souza <artur.souza@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

__author__ = "Artur Duque de Souza / Leonardo Sobral Cunha"
__author_email__ = "artur.souza@openbossa.org / leonardo.cunha@openbossa.org"

import os
import sys
import stat
import logging
import ConfigParser

from signal import SIGTERM

__all__ = ("which", "load_preferences")

log = logging.getLogger("atabake.utils")

def which(app):
    """Function to implement which(1) unix command"""
    pl = os.environ["PATH"].split(os.pathsep)
    for p in pl:
        path = os.path.join(p, app)
        if os.path.isfile(path):
            st = os.stat(path)
            if st[stat.ST_MODE] & 0111:
                return path
    return None


def load_preferences(config_file):
    """Function to load preferences for the player from a file"""
    preferences = {}
    config = ConfigParser.ConfigParser()
    try:
        config.read(config_file)
        for sec in config.sections():
            for opt in config.options(sec):
                preferences[opt] = config.get(sec, opt)
    except Exception, e:
        log.error(e, exc_info=True)
        raise

    return preferences
