#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <stdio.h>

#include <panel-applet.h>
#include <gtk/gtkbox.h>
#include <gtk/gtkimage.h>
#include <gconf/gconf-client.h>

GtkTooltips *tooltip;
GtkWidget   *image;
GtkWidget   *event_box;
gboolean     iconflag;

static gboolean
get_touchcruiser_mode(void)
{
	FILE *fp;
	char mode;

	fp = fopen( "/proc/oj6sh_wheel", "r" );
	if( fp == NULL ){
		return TRUE;
	}

	mode = getc( fp );
	fclose( fp );
	if( mode == '0' )
	{
		return TRUE;
	} else {
		return FALSE;
	}
}

void
set_tooltip(void)
{
	gboolean rtn;

	rtn = get_touchcruiser_mode ();
	if( rtn ){
		if( iconflag == FALSE ){
			gtk_container_remove (GTK_CONTAINER (event_box), image);
			image = gtk_image_new_from_file ("/usr/share/touchcruiser/cursor.png");
			gtk_tooltips_set_tip (tooltip, GTK_WIDGET (image), "カーソルモード", NULL);
			gtk_container_add (GTK_CONTAINER (event_box), image);
			iconflag = TRUE;
		}
	} else {
		if( iconflag == TRUE ){
			gtk_container_remove (GTK_CONTAINER (event_box), image);
			image = gtk_image_new_from_file ("/usr/share/touchcruiser/wheel.png");
			gtk_tooltips_set_tip (tooltip, GTK_WIDGET (image), "ホイールモード", NULL);
			gtk_container_add (GTK_CONTAINER (event_box), image);
			iconflag = FALSE;
		}
	}
	gtk_widget_show (GTK_WIDGET (image));
}

static gboolean
motion_notify_event (GtkWidget *widget,
                     GdkEventMotion *event )
{
	set_tooltip();

	return TRUE;
}

static void
gconf_changed (GConfClient *client,
               guint conn_id,
               GConfEntry *entry,
               gpointer user_data)
{
	set_tooltip();
}

static gboolean
applet_touchcruiser_fill (PanelApplet *applet,
   const gchar *iid,
   gpointer data)
{
	gboolean	rtn;
	GConfClient *client = gconf_client_get_default ();

	if (strcmp (iid, "OAFIID:TouchcruiserApplet") != 0)
		return FALSE;

	event_box = gtk_event_box_new ();
	tooltip = gtk_tooltips_new ();

	rtn = get_touchcruiser_mode ();
	if( rtn ){
		image = gtk_image_new_from_file ("/usr/share/touchcruiser/cursor.png");
		gtk_tooltips_set_tip (tooltip, GTK_WIDGET (image), "カーソルモード", NULL);
	} else {
		image = gtk_image_new_from_file ("/usr/share/touchcruiser/wheel.png");
		gtk_tooltips_set_tip (tooltip, GTK_WIDGET (image), "ホイールモード", NULL);
	}
	iconflag = rtn;
	gtk_container_add (GTK_CONTAINER (event_box), image);
	g_signal_connect (G_OBJECT (event_box), 
			          "motion_notify_event",
			          G_CALLBACK (motion_notify_event),
			          image);

	gconf_client_add_dir (client, "/apps/touchcruiser", GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_notify_add (client, "/apps/touchcruiser/value", (GConfClientNotifyFunc) gconf_changed, NULL, NULL, NULL);

	gtk_container_add (GTK_CONTAINER (applet), event_box);
	gtk_widget_show_all (GTK_WIDGET (applet));

	return TRUE;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:TouchcruiserApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "Touch Cruiser Applet",
                             "0",
                             applet_touchcruiser_fill,
                             NULL);
