/*
 * Copyright (C) 2012 Canonical, Ltd.
 *
 * Authors:
 *  Renato Araujo Oliveira Filho <renato@canonical.com>
 *  Ricardo Mendoza <ricmm@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ANDROID_ACCOUNT_INFO_H
#define ANDROID_ACCOUNT_INFO_H

#include <glib.h>

typedef struct _AccountInfo AccountInfo;
typedef struct _AccountInfoPrivate AccountInfoPrivate;

struct _AccountInfo {
    AccountInfoPrivate *priv;
};

// Account Fields
typedef enum {
    // Base information
    ACCOUNT_TYPE = 0,
    ACCOUNT_DISPLAY_NAME,
    ACCOUNT_EMAIL,
    ACCOUNT_SENDER_NAME,
    ACCOUNT_SIGNATURE,
    // Incoming server
    ACCOUNT_INCOMING_HOST_BASE,
    ACCOUNT_INCOMING_HOST_PROTOCOL,
    ACCOUNT_INCOMING_HOST_ADDRESS,
    ACCOUNT_INCOMING_HOST_PORT,
    ACCOUNT_INCOMING_HOST_FLAGS,
    ACCOUNT_INCOMING_HOST_LOGIN,
    ACCOUNT_INCOMING_HOST_DOMAIN,
    // Outgoing server
    ACCOUNT_OUTGOING_HOST_BASE,
    ACCOUNT_OUTGOING_HOST_PROTOCOL,
    ACCOUNT_OUTGOING_HOST_ADDRESS,
    ACCOUNT_OUTGOING_HOST_PORT,
    ACCOUNT_OUTGOING_HOST_FLAGS,
    ACCOUNT_OUTGOING_HOST_LOGIN,
    ACCOUNT_OUTGOING_HOST_DOMAIN,
} AccountInfoField;

AccountInfo*        account_info_new            (void);
void                account_info_destroy        (AccountInfo *self);
AccountInfo*        account_info_copy           (AccountInfo *self);
gint                account_info_compare        (AccountInfo *self,
                                                 AccountInfo *other);
gint                account_info_compare_field  (AccountInfo *self,
                                                 AccountInfo *other,
                                                 AccountInfoField field);
GVariant*           account_info_get_field      (AccountInfo *self,
                                                 AccountInfoField field);
void                account_info_set_field      (AccountInfo *self,
                                                 AccountInfoField field,
                                                 GVariant *value);
#endif
