/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is android-account-sync-extension.
 *
 * The Initial Developer of the Original Code is
 * Canonical, Ltd.
 * Portions created by the Initial Developer are Copyright (C) 2012
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Renato Araujo Oliveira Filho <renato@canonical.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */


var EXPORTED_SYMBOLS = [ "LibAccountManagerProxy" ];

const Cu = Components.utils;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://androidaccountsync/libaccountmanagerproxy-ctypes.jsm");
Cu.import("resource://androidaccountsync/LibGLib.jsm");

XPCOMUtils.defineLazyGetter(this, "AccountInfo", function() {
    return ctypes.StructType("AccountInfo");
});


XPCOMUtils.defineLazyGetter(this, "AndroidAccountManagerProxy", function() {
  return ctypes.StructType("AndroidAccountManagerProxy");
});

XPCOMUtils.defineLazyGetter(this, "AccountInfoField", function() {
  return ctypes.int;
})

XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_new", function() {
  var android_account_manager_proxy_new =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_new",
                                          ctypes.default_abi,
                                          AndroidAccountManagerProxy.ptr);
  if (!android_account_manager_proxy_new)
    throw "android_account_manager_proxy_new is unavailable";

  return android_account_manager_proxy_new;
});


XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_start_sync", function() {
  var android_account_manager_proxy_start_sync =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_start_sync",
                                          ctypes.default_abi,
                                          ctypes.void_t,
                                          AndroidAccountManagerProxy.ptr);
  if (!android_account_manager_proxy_start_sync)
    throw "android_account_manager_proxy_start_sync is unavailable";

  return android_account_manager_proxy_start_sync;
});

XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_register_account", function() {
  var android_account_manager_proxy_register_account =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_register_account",
                                          ctypes.default_abi,
                                          ctypes.void_t,
                                          AndroidAccountManagerProxy.ptr,
                                          AccountInfo.ptr);
  if (!android_account_manager_proxy_register_account)
    throw "android_account_manager_proxy_register_account is unavailable";

  return android_account_manager_proxy_register_account;
});


XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_unregister_account", function() {
  var android_account_manager_proxy_unregister_account =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_unregister_account",
                                          ctypes.default_abi,
                                          ctypes.void_t,
                                          AndroidAccountManagerProxy.ptr,
                                          LibGLib.gchar.ptr);
  if (!android_account_manager_proxy_unregister_account)
    throw "android_account_manager_proxy_unregister_account is unavailable";

  return android_account_manager_proxy_unregister_account;
});

XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_get_account", function() {
  var android_account_manager_proxy_get_account =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_get_account",
                                           ctypes.default_abi,
                                           AccountInfo.ptr,
                                           AndroidAccountManagerProxy.ptr,
                                           LibGLib.gchar.ptr);
  if (!android_account_manager_proxy_get_account)
    throw "android_account_manager_proxy_get_account is unavailable";

  return android_account_manager_proxy_get_account;
});

XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_handle_update", function() {
  var android_account_manager_proxy_handle_update =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_handle_update",
                                           ctypes.default_abi,
                                           ctypes.void_t,
                                           AndroidAccountManagerProxy.ptr,
                                           AccountInfo.ptr,
                                           AccountInfo.ptr);
  if (!android_account_manager_proxy_handle_update)
    throw "android_account_manager_proxy_handle_update is unavailable";

  return android_account_manager_proxy_handle_update;
});

XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_update_account", function() {
  var android_account_manager_proxy_update_account =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_update_account",
                                           ctypes.default_abi,
                                           ctypes.void_t,
                                           AndroidAccountManagerProxy.ptr,
                                           AccountInfo.ptr);
  if (!android_account_manager_proxy_update_account)
    throw "android_account_manager_proxy_update_account is unavailable";

  return android_account_manager_proxy_update_account;
});

XPCOMUtils.defineLazyGetter(this, "android_account_manager_proxy_create_account", function() {
  var android_account_manager_proxy_create_account =
    libandroidaccountmanagerproxy.declare("android_account_manager_proxy_create_account",
                                          ctypes.default_abi,
                                          ctypes.void_t,
                                          AndroidAccountManagerProxy.ptr,
                                          AccountInfo.ptr);
  if (!android_account_manager_proxy_create_account)
    throw "android_account_manager_proxy_create_account is unavailable";

  return android_account_manager_proxy_create_account;
});

// Account Info

XPCOMUtils.defineLazyGetter(this, "account_info_new", function() {
  var account_info_new =
    libandroidaccountmanagerproxy.declare("account_info_new",
                                          ctypes.default_abi,
                                          AccountInfo.ptr);
  if (!account_info_new)
    throw "android_account_manager_proxy_new is unavailable";

  return account_info_new;
});

XPCOMUtils.defineLazyGetter(this, "account_info_destroy", function() {
  var account_info_destroy =
    libandroidaccountmanagerproxy.declare("account_info_destroy",
                                          ctypes.default_abi,
                                          ctypes.void_t,
                                          AccountInfo.ptr);
  if (!account_info_destroy)
    throw "account_info_destroy is unavailable";

  return account_info_destroy;
});


XPCOMUtils.defineLazyGetter(this, "account_info_get_field", function() {
  var account_info_get_field =
    libandroidaccountmanagerproxy.declare("account_info_get_field",
                                          ctypes.default_abi,                        
                                          LibGLib.GVariant.ptr,
                                          AccountInfo.ptr,
                                          AccountInfoField);
  if (!account_info_get_field)
    throw "account_info_get_field is unavailable";

  return account_info_get_field;
});

XPCOMUtils.defineLazyGetter(this, "account_info_set_field", function() {
  var account_info_set_field =
    libandroidaccountmanagerproxy.declare("account_info_set_field",
                                          ctypes.default_abi,
                                          ctypes.void_t,
                                          AccountInfo.ptr,
                                          AccountInfoField,
                                          LibGLib.GVariant.ptr);
  if (!account_info_set_field)
    throw "account_info_set_field is unavailable";

  return account_info_set_field;
});


var LibAccountManagerProxy = {
  AccountInfo: AccountInfo,
  AndroidAccountManagerProxy: AndroidAccountManagerProxy,
  AccountInfoField: AccountInfoField,
  ACCOUNT_EMAIL: 2,
  ACCOUNT_SENDER_NAME: 3,
  ACCOUNT_SIGNATURE: 4,
  ACCOUNT_INCOMING_HOST_PROTOCOL: 6,
  ACCOUNT_INCOMING_HOST_ADDRESS: 7, 
  ACCOUNT_INCOMING_HOST_PORT: 8,
  ACCOUNT_INCOMING_HOST_LOGIN: 10,
  ACCOUNT_OUTGOING_HOST_PROTOCOL: 13,
  ACCOUNT_OUTGOING_HOST_ADDRESS: 14,
  ACCOUNT_OUTGOING_HOST_PORT: 15,
  ACCOUNT_OUTGOING_HOST_LOGIN: 17,

  FIELD_SENDER_NAME: 0,
  INC_HOST_LOGIN: 1,
  INC_HOST_PROTOCOL: 2,
  INC_HOST_PORT: 3,
  INC_HOST_ADDRESS: 4,
  OUT_HOST_LOGIN: 5,
  OUT_HOST_PORT: 6,
  OUT_HOST_ADDRESS: 7,

  newAccountManagerProxy: function PROXY_newAccountManagerProxy() {
    return android_account_manager_proxy_new();
  },

  startSync: function PROXY_startSync(proxy) {
    android_account_manager_proxy_start_sync(proxy);
  },

  handleUpdate: function PROXY_handleUpdate(proxy, server, local) {
    android_account_manager_proxy_handle_update(proxy, server, local);
  },

  registerAccount: function PROXY_registerAccount(proxy, account) {
    android_account_manager_proxy_register_account(proxy, account);
  },

  unregisterAccount: function PROXY_unregisterAccount(proxy, email) {
    android_account_manager_proxy_unregister_account(proxy, email);
  },

  getAccount: function PROXY_getAccount(proxy, email) {
    return android_account_manager_proxy_get_account(proxy, email);
  },

  updateAccount: function PROXY_updateAccount(proxy, account) {
    return android_account_manager_proxy_update_account(proxy, account);
  },

  createAccount: function PROXY_createAccount(proxy, account) {
    return android_account_manager_proxy_create_account(proxy, account);
  },

  newAccountInfo: function PROXY_newAccountInfo() {
    return account_info_new();
  },

  destroyAccountInfo: function PROXY_destroyAccountInfo(account) {
    account_info_destroy(account);
  },

  getAccountInfoField: function PROXY_getAccountInfoField(account, field) {
    return account_info_get_field(account, field);
  },

  setAccountInfoField: function PROXY_setAccountInfoField(account, field, value) {
    account_info_set_field(account, field, value);
  },
}

