#ifndef AMDGPU_BACKPORT_KCL_VGA_SWITCHEROO_H
#define AMDGPU_BACKPORT_KCL_VGA_SWITCHEROO_H

#include <linux/vga_switcheroo.h>

/**
 * arg change in mainline kernel 3.12
 * but only affect RHEL6 without backport
 */
static inline int kcl_vga_switcheroo_register_client(struct pci_dev *dev,
						     const struct vga_switcheroo_client_ops *ops,
						     bool driver_power_control)
{
#if defined(OS_NAME_RHEL_6)
	return vga_switcheroo_register_client(dev, ops);
#else
	return vga_switcheroo_register_client(dev, ops, driver_power_control);
#endif
}

#endif /* AMDGPU_BACKPORT_KCL_VGA_SWITCHEROO_H */
